/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.editPreferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.CustomJFileChooser;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.AbstractPreferencesPanel;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;

public final class PodcastFeedPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -1298749333908609956L;
    private JLabel retrievalIntervalLabel = new JLabel(I18nUtils.getString("PODCAST_FEED_ENTRIES_RETRIEVAL_INTERVAL"));
    private JComboBox retrievalInterval = new JComboBox<Long>(new Long[]{1L, 3L, 5L, 10L, 15L, 30L, 60L});
    private JLabel downloadFolderLabel = new JLabel(I18nUtils.getString("PODCAST_FEED_ENTRIES_DOWNLOAD_FOLDER"));
    private CustomJFileChooser downloadFolderFileChooser = new CustomJFileChooser(this, 20, 1);
    private JCheckBox useDownloadedPodcastFeedEntries = new JCheckBox(I18nUtils.getString("USE_DOWNLOADED_PODCAST_FEED_ENTRIES"));
    private JCheckBox removePodcastFeedEntriesRemovedFromPodcastFeed = new JCheckBox(I18nUtils.getString("REMOVE_PODCAST_FEED_ENTRIES_REMOVED_FROM_PODCAST_FEED"));

    public PodcastFeedPanel() {
        super(I18nUtils.getString("PODCAST_FEEDS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 23;
        this.add((Component)this.retrievalIntervalLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.retrievalInterval, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.downloadFolderLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.downloadFolderFileChooser, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.useDownloadedPodcastFeedEntries, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.removePodcastFeedEntriesRemovedFromPodcastFeed, gridBagConstraints);
    }

    @Override
    public boolean applyPreferences(ApplicationState applicationState) {
        applicationState.setPodcastFeedEntriesRetrievalInterval((Long)this.retrievalInterval.getSelectedItem() * 60L * 1000L);
        applicationState.setPodcastFeedEntryDownloadPath(this.downloadFolderFileChooser.getResult());
        applicationState.setUseDownloadedPodcastFeedEntries(this.useDownloadedPodcastFeedEntries.isSelected());
        applicationState.setRemovePodcastFeedEntriesRemovedFromPodcastFeed(this.removePodcastFeedEntriesRemovedFromPodcastFeed.isSelected());
        return false;
    }

    private void setRetrievalInterval(long l) {
        this.retrievalInterval.setSelectedItem(l / 1000L / 60L);
    }

    private void setDownloadPath(String string) {
        this.downloadFolderFileChooser.setText(string);
    }

    private void setUseDownloadedPodcastFeedEntries(boolean bl) {
        this.useDownloadedPodcastFeedEntries.setSelected(bl);
    }

    private void setRemovePodcastFeedEntriesRemovedFromPodcastFeed(boolean bl) {
        this.removePodcastFeedEntriesRemovedFromPodcastFeed.setSelected(bl);
    }

    @Override
    public void updatePanel(ApplicationState applicationState) {
        this.setRetrievalInterval(applicationState.getPodcastFeedEntriesRetrievalInterval());
        this.setDownloadPath(applicationState.getPodcastFeedEntryDownloadPath());
        this.setUseDownloadedPodcastFeedEntries(applicationState.isUseDownloadedPodcastFeedEntries());
        this.setRemovePodcastFeedEntriesRemovedFromPodcastFeed(applicationState.isRemovePodcastFeedEntriesRemovedFromPodcastFeed());
    }

    @Override
    public void resetImmediateChanges(ApplicationState applicationState) {
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void dialogVisibilityChanged(boolean bl) {
    }

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("rss_little.png");
    }
}

