/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.editPreferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.CustomTextField;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.AbstractPreferencesPanel;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.AddBannedSongInLastFMAction;
import net.sourceforge.atunes.kernel.actions.AddLovedSongInLastFMAction;
import net.sourceforge.atunes.kernel.actions.ImportLovedTracksFromLastFMAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.I18nUtils;

public final class LastFmPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -9216216930198145476L;
    private Logger logger;
    private JCheckBox lastFmEnabled;
    private JTextField lastFmUser;
    private JPasswordField lastFmPassword;
    private JButton testLogin;
    private JCheckBox autoLoveFavoriteSongs;

    public LastFmPanel() {
        super("Last.fm");
        JLabel jLabel = new JLabel(I18nUtils.getString("LASTFM_PREFERENCES"));
        this.lastFmEnabled = new JCheckBox(I18nUtils.getString("LASTFM_ENABLED"));
        JLabel jLabel2 = new JLabel(I18nUtils.getString("LASTFM_USER"));
        this.lastFmUser = new CustomTextField(15);
        JLabel jLabel3 = new JLabel(I18nUtils.getString("LASTFM_PASSWORD"));
        this.lastFmPassword = new JPasswordField(15);
        this.autoLoveFavoriteSongs = new JCheckBox(I18nUtils.getString("AUTOMATICALLY_LOVE_IN_LASTFM_FAVORITE_SONGS"));
        this.testLogin = new JButton(I18nUtils.getString("TEST_LOGIN"));
        this.testLogin.addActionListener(new TestLoginActionListener());
        this.lastFmEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LastFmPanel.this.enableControls();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.add((Component)this.lastFmEnabled, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.lastFmUser, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.lastFmPassword, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.testLogin, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        this.add((Component)this.autoLoveFavoriteSongs, gridBagConstraints);
    }

    @Override
    public boolean applyPreferences(ApplicationState applicationState) {
        applicationState.setLastFmUser(this.lastFmUser.getText());
        applicationState.setLastFmPassword(String.valueOf(this.lastFmPassword.getPassword()));
        applicationState.setLastFmEnabled(this.lastFmEnabled.isSelected());
        applicationState.setAutoLoveFavoriteSong(this.autoLoveFavoriteSongs.isSelected());
        Actions.getAction(AddLovedSongInLastFMAction.class).setEnabled(applicationState.isLastFmEnabled());
        Actions.getAction(AddBannedSongInLastFMAction.class).setEnabled(applicationState.isLastFmEnabled());
        Actions.getAction(ImportLovedTracksFromLastFMAction.class).setEnabled(applicationState.isLastFmEnabled());
        return false;
    }

    private void setLastFmEnabled(boolean bl) {
        this.lastFmEnabled.setSelected(bl);
    }

    private void setLastFmPassword(String string) {
        this.lastFmPassword.setText(string);
    }

    private void setLastFmUser(String string) {
        this.lastFmUser.setText(string);
    }

    private void setAutoLoveFavoriteSong(boolean bl) {
        this.autoLoveFavoriteSongs.setSelected(bl);
    }

    @Override
    public void updatePanel(ApplicationState applicationState) {
        this.setLastFmUser(applicationState.getLastFmUser());
        this.setLastFmPassword(applicationState.getLastFmPassword());
        this.setLastFmEnabled(applicationState.isLastFmEnabled());
        this.setAutoLoveFavoriteSong(applicationState.isAutoLoveFavoriteSong());
        this.enableControls();
    }

    protected void enableControls() {
        boolean bl = this.lastFmEnabled.isSelected();
        this.lastFmUser.setEnabled(bl);
        this.lastFmPassword.setEnabled(bl);
        this.autoLoveFavoriteSongs.setEnabled(bl);
        this.testLogin.setEnabled(bl);
    }

    @Override
    public void resetImmediateChanges(ApplicationState applicationState) {
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void dialogVisibilityChanged(boolean bl) {
    }

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("lastFm.png");
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private final class TestLoginActionListener
    implements ActionListener {
        private TestLoginActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LastFmPanel.this.testLogin.setEnabled(false);
            new TestLoginSwingWorker().execute();
        }

        private final class TestLoginSwingWorker
        extends SwingWorker<Boolean, Void> {
            private TestLoginSwingWorker() {
            }

            @Override
            protected Boolean doInBackground() {
                return LastFmService.getInstance().testLogin(LastFmPanel.this.lastFmUser.getText(), String.valueOf(LastFmPanel.this.lastFmPassword.getPassword()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    boolean bl = (Boolean)this.get();
                    if (bl) {
                        GuiHandler.getInstance().showMessage(I18nUtils.getString("LOGIN_SUCCESSFUL"));
                    } else {
                        GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("LOGIN_FAILED"));
                    }
                }
                catch (InterruptedException interruptedException) {
                    LastFmPanel.this.getLogger().error("SERVICE     ", interruptedException);
                }
                catch (ExecutionException executionException) {
                    LastFmPanel.this.getLogger().error("SERVICE     ", executionException);
                }
                finally {
                    LastFmPanel.this.testLogin.setEnabled(true);
                }
            }
        }
    }
}

