/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.editPreferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.CustomTextField;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.AbstractPreferencesPanel;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.beans.ProxyBean;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.I18nUtils;

public final class InternetPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -1872565673079044088L;
    private Logger logger;
    private JRadioButton noProxyRadioButton;
    private JRadioButton httpProxyRadioButton;
    private JRadioButton socksProxyRadioButton;
    private JLabel proxyURLLabel;
    private JTextField proxyURL;
    private JLabel proxyPortLabel;
    private JTextField proxyPort;
    private JLabel proxyUserLabel;
    private JTextField proxyUser;
    private JLabel proxyPasswordLabel;
    private JPasswordField proxyPassword;

    public InternetPanel() {
        super(I18nUtils.getString("INTERNET"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.noProxyRadioButton = new JRadioButton(I18nUtils.getString("NO_PROXY"));
        this.noProxyRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InternetPanel.this.enableProxySettings(false);
            }
        });
        this.httpProxyRadioButton = new JRadioButton(I18nUtils.getString("HTTP_PROXY"));
        this.httpProxyRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InternetPanel.this.enableProxySettings(true);
            }
        });
        this.socksProxyRadioButton = new JRadioButton(I18nUtils.getString("SOCKS_PROXY"));
        this.socksProxyRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InternetPanel.this.enableProxySettings(true);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.noProxyRadioButton);
        buttonGroup.add(this.httpProxyRadioButton);
        buttonGroup.add(this.socksProxyRadioButton);
        this.proxyURLLabel = new JLabel(I18nUtils.getString("HOST"));
        this.proxyURLLabel.setEnabled(false);
        this.proxyURL = new CustomTextField(15);
        this.proxyPortLabel = new JLabel(I18nUtils.getString("PORT"));
        this.proxyPortLabel.setEnabled(false);
        this.proxyPort = new CustomTextField(15);
        this.proxyPort.setEnabled(false);
        this.proxyUserLabel = new JLabel(I18nUtils.getString("USER"));
        this.proxyUserLabel.setEnabled(false);
        this.proxyUser = new CustomTextField(15);
        this.proxyUser.setEnabled(false);
        this.proxyPasswordLabel = new JLabel(I18nUtils.getString("PASSWORD"));
        this.proxyPasswordLabel.setEnabled(false);
        this.proxyPassword = new JPasswordField(15);
        this.proxyPassword.setEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 21;
        this.add((Component)this.noProxyRadioButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.httpProxyRadioButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.socksProxyRadioButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.add((Component)this.proxyURLLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.proxyURL, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.add((Component)this.proxyPortLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.proxyPort, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.add((Component)this.proxyUserLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.proxyUser, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 23;
        this.add((Component)this.proxyPasswordLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.proxyPassword, gridBagConstraints);
    }

    void enableProxySettings(boolean bl) {
        this.proxyURLLabel.setEnabled(bl);
        this.proxyURL.setEnabled(bl);
        this.proxyPortLabel.setEnabled(bl);
        this.proxyPort.setEnabled(bl);
        this.proxyUserLabel.setEnabled(bl);
        this.proxyUser.setEnabled(bl);
        this.proxyPasswordLabel.setEnabled(bl);
        this.proxyPassword.setEnabled(bl);
    }

    private ProxyBean getProxy() {
        if (this.noProxyRadioButton.isSelected()) {
            return null;
        }
        int n = Integer.parseInt(this.proxyPort.getText());
        String string = this.httpProxyRadioButton.isSelected() ? "HTTP_PROXY" : "SOCKS_PROXY";
        ProxyBean proxyBean = new ProxyBean();
        proxyBean.setUrl(this.proxyURL.getText());
        proxyBean.setPort(n);
        proxyBean.setUser(this.proxyUser.getText());
        proxyBean.setPassword(new String(this.proxyPassword.getPassword()));
        proxyBean.setType(string);
        return proxyBean;
    }

    @Override
    public boolean applyPreferences(ApplicationState applicationState) {
        ProxyBean proxyBean = this.getProxy();
        applicationState.setProxy(proxyBean);
        try {
            Proxy.initProxy(Proxy.getProxy(proxyBean));
        }
        catch (UnknownHostException unknownHostException) {
            this.getLogger().error("CONTROLLER  ", unknownHostException);
        }
        catch (IOException iOException) {
            this.getLogger().error("CONTROLLER  ", iOException);
        }
        return false;
    }

    @Override
    public boolean validatePanel() {
        return this.validateOptions();
    }

    private void setConfiguration(ProxyBean proxyBean) {
        this.enableProxySettings(proxyBean != null);
        if (proxyBean == null) {
            this.noProxyRadioButton.setSelected(true);
        } else if (proxyBean.getType().equals("HTTP_PROXY")) {
            this.httpProxyRadioButton.setSelected(true);
        } else {
            this.socksProxyRadioButton.setSelected(true);
        }
        this.proxyURL.setText(proxyBean != null ? proxyBean.getUrl() : "");
        this.proxyPort.setText(proxyBean != null ? Integer.toString(proxyBean.getPort()) : "");
        this.proxyUser.setText(proxyBean != null ? proxyBean.getUser() : "");
        this.proxyPassword.setText(proxyBean != null ? proxyBean.getPassword() : "");
    }

    private boolean validateOptions() {
        try {
            if (!this.noProxyRadioButton.isSelected()) {
                Integer.parseInt(this.proxyPort.getText());
                return true;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, I18nUtils.getString("INCORRECT_PORT"));
            return false;
        }
    }

    @Override
    public void updatePanel(ApplicationState applicationState) {
        this.setConfiguration(applicationState.getProxy());
    }

    @Override
    public void resetImmediateChanges(ApplicationState applicationState) {
    }

    @Override
    public void dialogVisibilityChanged(boolean bl) {
    }

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("network_little.png");
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

