/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.editPreferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.controls.CustomTextField;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.AbstractPreferencesPanel;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.ClearCachesAction;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines.LyricsEngineInfo;
import net.sourceforge.atunes.utils.DesktopUtils;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class ContextPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -9216216930198145476L;
    private JCheckBox activateContext = new JCheckBox(I18nUtils.getString("ACTIVATE_CONTEXT_INFORMATION"));
    private JCheckBox savePictures = new JCheckBox(I18nUtils.getString("SAVE_PICTURES_TO_AUDIO_FOLDERS"));
    private JCheckBox showTextInTabs = new JCheckBox(I18nUtils.getString("SHOW_CONTEXT_TABS_TEXT"));
    private JCheckBox hideVariousArtistsAlbums = new JCheckBox(I18nUtils.getString("HIDE_VARIOUS_ARTISTS_ALBUMS"));
    private JCheckBox minimumSongNumberPerAlbum = new JCheckBox(I18nUtils.getString("MINIMUM_SONG_NUMBER_PER_ALBUM"));
    private JTextField minimumSongNumber = new CustomTextField(4);
    private JCheckBox showAlbumsInGrid;
    private JLabel info;
    private JTable enginesTable;

    public ContextPanel() {
        super(I18nUtils.getString("CONTEXT_INFORMATION"));
        this.minimumSongNumber.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (!Character.isDigit(keyEvent.getKeyChar()) || ContextPanel.this.minimumSongNumber.getText().length() > 2) {
                    keyEvent.consume();
                }
            }
        });
        this.minimumSongNumberPerAlbum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ContextPanel.this.minimumSongNumber.setEnabled(ContextPanel.this.minimumSongNumberPerAlbum.isSelected());
            }
        });
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.add(this.minimumSongNumberPerAlbum);
        box.add(Box.createHorizontalStrut(6));
        box.add(this.minimumSongNumber);
        box.add(Box.createHorizontalGlue());
        this.minimumSongNumber.setMinimumSize(new Dimension(50, 20));
        this.showAlbumsInGrid = new JCheckBox(I18nUtils.getString("SHOW_ALBUMS_IN_GRID"));
        this.activateContext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ContextPanel.this.savePictures.setEnabled(ContextPanel.this.activateContext.isSelected());
                ContextPanel.this.showTextInTabs.setEnabled(ContextPanel.this.activateContext.isSelected());
                ContextPanel.this.hideVariousArtistsAlbums.setEnabled(ContextPanel.this.activateContext.isSelected());
            }
        });
        JButton jButton = new JButton(Actions.getAction(ClearCachesAction.class));
        this.info = new JLabel(Images.getImage("poweredByLastFm.png"), GuiUtils.getComponentOrientationAsSwingConstant());
        this.info.addMouseListener(new OpenLastFmMouseAdapter());
        JLabel jLabel = new JLabel(I18nUtils.getString("LYRICS_ENGINES_SELECTION"));
        final LyricsEnginesTableModel lyricsEnginesTableModel = new LyricsEnginesTableModel();
        this.enginesTable = new JTable(lyricsEnginesTableModel);
        this.enginesTable.setShowGrid(false);
        this.enginesTable.setTableHeader(null);
        this.enginesTable.getColumnModel().getColumn(0).setMaxWidth(20);
        this.enginesTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.enginesTable.getSelectionModel().setSelectionMode(0);
        this.enginesTable.setDefaultRenderer(String.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(GuiUtils.getComponentOrientationTableCellRendererCode()));
        JButton jButton2 = new JButton(Images.getImage("go-up.png"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ContextPanel.this.enginesTable.getSelectedRow();
                if (n > 0) {
                    lyricsEnginesTableModel.moveUp(n);
                }
            }
        });
        JButton jButton3 = new JButton(Images.getImage("go-down.png"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ContextPanel.this.enginesTable.getSelectedRow();
                if (n < ContextPanel.this.enginesTable.getModel().getRowCount() - 1) {
                    lyricsEnginesTableModel.moveDown(n);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.enginesTable);
        jScrollPane.setMinimumSize(new Dimension(200, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 23;
        this.add((Component)this.activateContext, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.savePictures, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.showTextInTabs, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.hideVariousArtistsAlbums, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.add((Component)box, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.add((Component)this.showAlbumsInGrid, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 23;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.info, gridBagConstraints);
    }

    @Override
    public boolean applyPreferences(ApplicationState applicationState) {
        applicationState.setUseContext(this.activateContext.isSelected());
        applicationState.setSaveContextPicture(this.savePictures.isSelected());
        applicationState.setShowContextTabsText(this.showTextInTabs.isSelected());
        applicationState.setHideVariousArtistsAlbums(this.hideVariousArtistsAlbums.isSelected());
        applicationState.setMinimumSongNumberPerAlbum(this.minimumSongNumberPerAlbum.isSelected() ? Integer.parseInt(this.minimumSongNumber.getText()) : 0);
        applicationState.setLyricsEnginesInfo(((LyricsEnginesTableModel)this.enginesTable.getModel()).getLyricsEnginesInfo());
        boolean bl = applicationState.isShowContextAlbumsInGrid();
        applicationState.setShowContextAlbumsInGrid(this.showAlbumsInGrid.isSelected());
        return bl != this.showAlbumsInGrid.isSelected();
    }

    private void setActivateContext(boolean bl) {
        this.activateContext.setSelected(bl);
        this.savePictures.setEnabled(bl);
        this.showTextInTabs.setEnabled(bl);
        this.hideVariousArtistsAlbums.setEnabled(bl);
    }

    private void setSavePictures(boolean bl) {
        this.savePictures.setSelected(bl);
    }

    private void setShowTextInTabs(boolean bl) {
        this.showTextInTabs.setSelected(bl);
    }

    private void setHideVariousArtistsAlbums(boolean bl) {
        this.hideVariousArtistsAlbums.setSelected(bl);
    }

    private void setMinimumSongNumberPerAlbum(int n) {
        this.minimumSongNumberPerAlbum.setSelected(n != 0);
        this.minimumSongNumber.setEnabled(n != 0);
        this.minimumSongNumber.setText(Integer.toString(n));
    }

    private void setLyricsEnginesInfo(List<LyricsEngineInfo> list) {
        ArrayList<LyricsEngineInfo> arrayList = new ArrayList<LyricsEngineInfo>();
        for (LyricsEngineInfo lyricsEngineInfo : list) {
            arrayList.add(new LyricsEngineInfo(lyricsEngineInfo.getName(), lyricsEngineInfo.getClazz(), lyricsEngineInfo.isEnabled()));
        }
        ((LyricsEnginesTableModel)this.enginesTable.getModel()).setLyricsEnginesInfo(arrayList);
    }

    private void setShowAlbumsInGrid(boolean bl) {
        this.showAlbumsInGrid.setSelected(bl);
    }

    @Override
    public void updatePanel(ApplicationState applicationState) {
        this.setActivateContext(applicationState.isUseContext());
        this.setSavePictures(applicationState.isSaveContextPicture());
        this.setShowTextInTabs(applicationState.isShowContextTabsText());
        this.setHideVariousArtistsAlbums(applicationState.isHideVariousArtistsAlbums());
        this.setMinimumSongNumberPerAlbum(applicationState.getMinimumSongNumberPerAlbum());
        this.setLyricsEnginesInfo(applicationState.getLyricsEnginesInfo());
        this.setShowAlbumsInGrid(applicationState.isShowContextAlbumsInGrid());
    }

    @Override
    public void resetImmediateChanges(ApplicationState applicationState) {
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void dialogVisibilityChanged(boolean bl) {
    }

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("context.png");
    }

    private class LyricsEnginesTableModel
    implements TableModel {
        private List<LyricsEngineInfo> lyricsEnginesInfo = new ArrayList<LyricsEngineInfo>();
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();

        LyricsEnginesTableModel() {
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
            this.listeners.add(tableModelListener);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return n == 0 ? Boolean.class : String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            return "";
        }

        @Override
        public int getRowCount() {
            if (this.lyricsEnginesInfo != null) {
                return this.lyricsEnginesInfo.size();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.lyricsEnginesInfo.get(n).isEnabled();
            }
            return this.lyricsEnginesInfo.get(n).getName();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void moveDown(int n) {
            Collections.swap(this.lyricsEnginesInfo, n, n + 1);
            TableModelEvent tableModelEvent = new TableModelEvent(this, -1, 0);
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).tableChanged(tableModelEvent);
            }
            ContextPanel.this.enginesTable.getColumnModel().getColumn(0).setMaxWidth(20);
            ContextPanel.this.enginesTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
        }

        public void moveUp(int n) {
            Collections.swap(this.lyricsEnginesInfo, n, n - 1);
            TableModelEvent tableModelEvent = new TableModelEvent(this, -1, 0);
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).tableChanged(tableModelEvent);
            }
            ContextPanel.this.enginesTable.getColumnModel().getColumn(0).setMaxWidth(20);
            ContextPanel.this.enginesTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.listeners.remove(tableModelListener);
        }

        public void setLyricsEnginesInfo(List<LyricsEngineInfo> list) {
            this.lyricsEnginesInfo = new ArrayList<LyricsEngineInfo>(list);
        }

        public List<LyricsEngineInfo> getLyricsEnginesInfo() {
            return new ArrayList<LyricsEngineInfo>(this.lyricsEnginesInfo);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.lyricsEnginesInfo.get(n).setEnabled((Boolean)object);
            }
        }
    }

    private static class OpenLastFmMouseAdapter
    extends MouseAdapter {
        private OpenLastFmMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            DesktopUtils.openURL("http://www.last.fm");
        }
    }
}

