/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalDialog;
import net.sourceforge.atunes.gui.views.controls.CustomTextField;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.commonjukebox.plugins.model.PluginConfiguration;
import org.commonjukebox.plugins.model.PluginInfo;
import org.commonjukebox.plugins.model.PluginProperty;

public class PluginEditorDialog
extends AbstractCustomModalDialog {
    private static final long serialVersionUID = -2629422819919724654L;
    private PluginConfiguration configuration;

    public PluginEditorDialog(Window window, PluginInfo pluginInfo, PluginConfiguration pluginConfiguration) {
        super(window, GuiUtils.getComponentWidthForResolution(1280, 500), GuiUtils.getComponentHeightForResolution(1024, 300), true);
        this.configuration = pluginConfiguration;
        this.setResizable(true);
        this.setTitle(StringUtils.getString(I18nUtils.getString("PLUGIN_PROPERTIES_EDITOR"), ": ", pluginInfo.getName()));
        this.add(this.getContent());
        GuiUtils.applyComponentOrientation(this);
        this.enableCloseActionWithEscapeKey();
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        PluginConfigurationPanel pluginConfigurationPanel = new PluginConfigurationPanel(this.configuration);
        jPanel.add((Component)new JScrollPane(pluginConfigurationPanel), "Center");
        JButton jButton = new JButton(I18nUtils.getString("OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginEditorDialog.this.setVisible(false);
            }
        });
        JButton jButton2 = new JButton(I18nUtils.getString("CANCEL"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginEditorDialog.this.configuration = null;
                PluginEditorDialog.this.setVisible(false);
            }
        });
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        jPanel2.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 10;
        jPanel2.add((Component)jButton2, gridBagConstraints);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    public PluginConfiguration getConfiguration() {
        return this.configuration;
    }

    private static class PluginConfigurationPanel
    extends JPanel {
        private static final long serialVersionUID = 8063088904049173181L;
        private PluginConfiguration configuration;

        public PluginConfigurationPanel(PluginConfiguration pluginConfiguration) {
            super(new GridBagLayout());
            this.configuration = pluginConfiguration;
            this.addContent();
        }

        private void addContent() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            for (String string : this.configuration.getPropertiesNames()) {
                PluginProperty pluginProperty = this.configuration.getProperty(string);
                JLabel jLabel = this.getPropertyLabel(pluginProperty);
                JComponent jComponent = this.getPropertyEditor(pluginProperty);
                if (gridBagConstraints.gridy == this.configuration.getPropertiesCount() - 1) {
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.anchor = 18;
                }
                gridBagConstraints.gridx = 0;
                this.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                this.add((Component)jComponent, gridBagConstraints);
                ++gridBagConstraints.gridy;
            }
        }

        private JLabel getPropertyLabel(PluginProperty<?> pluginProperty) {
            return new JLabel(pluginProperty.getDescription());
        }

        private JComponent getPropertyEditor(PluginProperty<?> pluginProperty) {
            CustomTextField customTextField = new CustomTextField(pluginProperty.getValue().toString());
            customTextField.addKeyListener(new TextFieldKeyAdapter(customTextField, pluginProperty));
            return customTextField;
        }

        private static final class TextFieldKeyAdapter
        extends KeyAdapter {
            private final JTextField textField;
            private final PluginProperty<?> property;

            private TextFieldKeyAdapter(JTextField jTextField, PluginProperty<?> pluginProperty) {
                this.textField = jTextField;
                this.property = pluginProperty;
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                super.keyTyped(keyEvent);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextFieldKeyAdapter.this.property.setValue((Object)TextFieldKeyAdapter.this.textField.getText());
                    }
                });
            }
        }
    }
}

