/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.ConstructorProperties;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalDialog;
import net.sourceforge.atunes.kernel.modules.state.beans.FontBean;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class FontChooserDialog
extends AbstractCustomModalDialog {
    private static final long serialVersionUID = 2941323406891892062L;
    private static final Integer[] FONT_SIZES = new Integer[]{6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    private JList fontList;
    private JList fontSizeList;
    private JCheckBox useFontSmoothingCheckbox;
    private JCheckBox useFontSmoothingSettingsFromOsCheckbox;
    private JLabel fontPreviewLabel;
    private JButton okButton;
    private JButton cancelButton;
    private Locale locale;
    private FontSettings fontSettings = new FontSettings();

    public FontChooserDialog(Window window, int n, int n2, Font font, boolean bl, boolean bl2, Locale locale) {
        super(window, n, n2, true);
        this.locale = locale;
        this.fontSettings.setFont(new FontBean(font));
        this.fontSettings.setUseFontSmoothing(bl);
        this.fontSettings.setUseFontSmoothingSettingsFromOs(bl2);
        this.setResizable(false);
        this.setTitle(I18nUtils.getString("FONT_SETTINGS"));
        this.setContent(this.getContent());
        GuiUtils.applyComponentOrientation(this);
        this.enableDisposeActionWithEscapeKey();
    }

    private JPanel getContent() {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(this.locale);
        this.fontPreviewLabel = new JLabel();
        this.fontPreviewLabel.setMinimumSize(new Dimension(50, 20));
        this.fontPreviewLabel.setMaximumSize(new Dimension(50, 20));
        this.fontPreviewLabel.setHorizontalAlignment(0);
        this.fontPreviewLabel.setText("Test Test");
        this.fontList = new JList<String>(stringArray);
        this.fontList.setSelectionMode(0);
        this.fontList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FontChooserDialog.this.fontSettings.setFont(new FontBean(new Font(FontChooserDialog.this.fontList.getSelectedValue().toString(), FontChooserDialog.this.fontSettings.getFont().getStyle(), FontChooserDialog.this.fontSettings.getFont().getSize())));
                FontChooserDialog.this.updatePreview();
            }
        });
        this.fontList.setSelectedValue(this.fontSettings.getFont().getName(), true);
        this.fontSizeList = new JList<Integer>(FONT_SIZES);
        this.fontSizeList.setSelectionMode(0);
        this.fontSizeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FontChooserDialog.this.fontSettings.setFont(new FontBean(FontChooserDialog.this.fontSettings.getFont().toFont().deriveFont(Float.valueOf(FontChooserDialog.this.fontSizeList.getSelectedValue().toString()).floatValue())));
                FontChooserDialog.this.updatePreview();
            }
        });
        this.fontSizeList.setSelectedValue(this.fontSettings.font.getSize(), true);
        this.useFontSmoothingCheckbox = new JCheckBox(I18nUtils.getString("USE_FONT_SMOOTHING"));
        this.useFontSmoothingCheckbox.setSelected(this.fontSettings.isUseFontSmoothing());
        this.useFontSmoothingCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                FontChooserDialog.this.fontSettings.setUseFontSmoothing(FontChooserDialog.this.useFontSmoothingCheckbox.isSelected());
            }
        });
        this.useFontSmoothingCheckbox.setSelected(this.fontSettings.isUseFontSmoothing());
        this.useFontSmoothingSettingsFromOsCheckbox = new JCheckBox(I18nUtils.getString("USE_OS_SETTINGS_FOR_FONT_SMOOTHING"));
        this.useFontSmoothingSettingsFromOsCheckbox.setSelected(this.fontSettings.isUseFontSmoothingSettingsFromOs());
        this.useFontSmoothingSettingsFromOsCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                FontChooserDialog.this.fontSettings.setUseFontSmoothingSettingsFromOs(FontChooserDialog.this.useFontSmoothingSettingsFromOsCheckbox.isSelected());
                FontChooserDialog.this.useFontSmoothingCheckbox.setEnabled(!FontChooserDialog.this.useFontSmoothingSettingsFromOsCheckbox.isSelected());
            }
        });
        this.useFontSmoothingSettingsFromOsCheckbox.setSelected(this.fontSettings.isUseFontSmoothingSettingsFromOs());
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooserDialog.this.dispose();
            }
        });
        this.okButton.setText(I18nUtils.getString("OK"));
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooserDialog.this.fontSettings = null;
                FontChooserDialog.this.dispose();
            }
        });
        this.cancelButton.setText(I18nUtils.getString("CANCEL"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)new JScrollPane(this.fontList), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)new JScrollPane(this.fontSizeList), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.fontPreviewLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        jPanel.add((Component)this.useFontSmoothingCheckbox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        jPanel.add((Component)this.useFontSmoothingSettingsFromOsCheckbox, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    private void updatePreview() {
        this.fontPreviewLabel.setFont(this.fontSettings.getFont().toFont());
    }

    public FontSettings getSelectedFontSettings() {
        return this.fontSettings;
    }

    public static class FontSettings {
        private FontBean font;
        private boolean useFontSmoothing;
        private boolean useFontSmoothingSettingsFromOs;

        @ConstructorProperties(value={"font", "useFontSmoothing", "useFontSmoothingSettingsFromOs"})
        public FontSettings(FontBean fontBean, boolean bl, boolean bl2) {
            this.font = fontBean;
            this.useFontSmoothing = bl;
            this.useFontSmoothingSettingsFromOs = bl2;
        }

        public FontSettings() {
        }

        void setFont(FontBean fontBean) {
            this.font = fontBean;
        }

        public FontBean getFont() {
            return this.font;
        }

        void setUseFontSmoothing(boolean bl) {
            this.useFontSmoothing = bl;
        }

        public boolean isUseFontSmoothing() {
            return this.useFontSmoothing;
        }

        void setUseFontSmoothingSettingsFromOs(boolean bl) {
            this.useFontSmoothingSettingsFromOs = bl;
        }

        public boolean isUseFontSmoothingSettingsFromOs() {
            return this.useFontSmoothingSettingsFromOs;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.font == null ? 0 : this.font.hashCode());
            n = 31 * n + (this.useFontSmoothing ? 1231 : 1237);
            n = 31 * n + (this.useFontSmoothingSettingsFromOs ? 1231 : 1237);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FontSettings fontSettings = (FontSettings)object;
            if (this.font == null ? fontSettings.font != null : !this.font.equals(fontSettings.font)) {
                return false;
            }
            if (this.useFontSmoothing != fontSettings.useFontSmoothing) {
                return false;
            }
            return this.useFontSmoothingSettingsFromOs == fontSettings.useFontSmoothingSettingsFromOs;
        }
    }
}

