/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalDialog;
import net.sourceforge.atunes.gui.views.controls.CustomButton;
import net.sourceforge.atunes.gui.views.controls.CustomJFileChooser;
import net.sourceforge.atunes.gui.views.controls.CustomTextArea;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class ExportOptionsDialog
extends AbstractCustomModalDialog {
    private static final long serialVersionUID = 4403091324599627762L;
    private JRadioButton currentNavigatorSelectionRadioButton;
    private JRadioButton currentPlayListSelectionRadioButton;
    private CustomJFileChooser exportLocationFileChooser;
    private JButton exportButton;
    private boolean cancel;

    public ExportOptionsDialog(JFrame jFrame) {
        super((Window)jFrame, 400, 220, true);
        this.setResizable(false);
        this.setTitle(I18nUtils.getString("EXPORT"));
        this.setContent(this.getContent());
        GuiUtils.applyComponentOrientation(this);
        this.enableCloseActionWithEscapeKey();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                ExportOptionsDialog.this.cancel = true;
            }
        });
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        CustomTextArea customTextArea = new CustomTextArea(I18nUtils.getString("EXPORT_INSTRUCTIONS"));
        customTextArea.setWrapStyleWord(true);
        customTextArea.setLineWrap(true);
        customTextArea.setEditable(false);
        customTextArea.setOpaque(false);
        customTextArea.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        this.currentNavigatorSelectionRadioButton = new JRadioButton(I18nUtils.getString("CURRENT_NAVIGATOR_SELECTION"));
        this.currentPlayListSelectionRadioButton = new JRadioButton(I18nUtils.getString("CURRENT_PLAYLIST_SELECTION"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.currentNavigatorSelectionRadioButton);
        buttonGroup.add(this.currentPlayListSelectionRadioButton);
        jPanel2.add(this.currentNavigatorSelectionRadioButton);
        jPanel2.add(this.currentPlayListSelectionRadioButton);
        this.currentNavigatorSelectionRadioButton.setSelected(true);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(I18nUtils.getString("LOCATION"));
        jPanel3.add((Component)jLabel, "West");
        this.exportLocationFileChooser = new CustomJFileChooser(this, 20, 1);
        jPanel3.add((Component)this.exportLocationFileChooser, "Center");
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2, 5, 0));
        jPanel4.setOpaque(false);
        this.exportButton = new CustomButton(null, I18nUtils.getString("EXPORT"));
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportOptionsDialog.this.setVisible(false);
            }
        });
        CustomButton customButton = new CustomButton(null, I18nUtils.getString("CANCEL"));
        customButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportOptionsDialog.this.cancel = true;
                ExportOptionsDialog.this.setVisible(false);
            }
        });
        jPanel4.add(this.exportButton);
        jPanel4.add(customButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        jPanel.add((Component)customTextArea, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 15, 0, 15);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        jPanel.add((Component)jPanel4, gridBagConstraints);
        return jPanel;
    }

    public JButton getExportButton() {
        return this.exportButton;
    }

    public String getExportLocation() {
        return this.exportLocationFileChooser.getResult();
    }

    public void startDialog() {
        this.cancel = false;
        super.setVisible(true);
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public boolean exportNavigatorSelection() {
        return this.currentNavigatorSelectionRadioButton.isSelected();
    }
}

