/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import net.sourceforge.atunes.gui.views.controls.CustomDialog;
import net.sourceforge.atunes.gui.views.controls.CustomTextField;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class CustomSearchDialog
extends CustomDialog {
    private static final long serialVersionUID = -7447583622785097610L;
    private JPanel searchAtPanel;
    private JLabel searchAtLabel;
    private JComboBox searchAtComboBox;
    private JPanel simpleRulesPanel;
    private JScrollPane simpleRulesScrollPane;
    private JList simpleRulesList;
    private JComboBox simpleRulesComboBox;
    private JTextField simpleRulesTextField;
    private JButton simpleRulesAddButton;
    private JPanel complexRulesPanel;
    private JTree complexRulesTree;
    private JScrollPane complexRulesScrollPane;
    private JButton complexRulesAndButton;
    private JButton complexRulesOrButton;
    private JButton complexRulesNotButton;
    private JButton complexRulesRemoveButton;
    private JPanel advancedSearchPanel;
    private JCheckBox advancedSearchCheckBox;
    private JTextField advancedSearchTextField;
    private JPanel buttonsPanel;
    private JButton searchButton;
    private JButton cancelButton;

    public CustomSearchDialog(JFrame jFrame) {
        super(jFrame, 600, 500);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setTitle(I18nUtils.getString("SEARCH"));
        this.add(this.getContent());
        GuiUtils.applyComponentOrientation(this);
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.getSearchAtPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.getSimpleRulesPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.getComplexRulesPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.getAdvancedSearchPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.getButtonsPanel(), gridBagConstraints);
        return jPanel;
    }

    private JPanel getSearchAtPanel() {
        if (this.searchAtPanel == null) {
            this.searchAtPanel = new JPanel();
            this.searchAtPanel.setBorder(BorderFactory.createEtchedBorder());
            this.searchAtLabel = new JLabel(I18nUtils.getString("SEARCH_IN"));
            this.searchAtComboBox = new JComboBox();
            this.searchAtPanel.add(this.searchAtLabel);
            this.searchAtPanel.add(this.searchAtComboBox);
        }
        return this.searchAtPanel;
    }

    public JPanel getSimpleRulesPanel() {
        if (this.simpleRulesPanel == null) {
            this.simpleRulesPanel = new JPanel(new GridBagLayout());
            this.simpleRulesPanel.setBorder(BorderFactory.createEtchedBorder());
            this.simpleRulesList = new JList();
            this.simpleRulesList.setSelectionMode(0);
            this.simpleRulesScrollPane = new JScrollPane(this.simpleRulesList);
            this.simpleRulesComboBox = new JComboBox();
            this.simpleRulesTextField = new CustomTextField();
            this.simpleRulesAddButton = new JButton(I18nUtils.getString("ADD"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            this.simpleRulesPanel.add((Component)this.simpleRulesScrollPane, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.3;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            this.simpleRulesPanel.add((Component)this.simpleRulesComboBox, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.7;
            this.simpleRulesPanel.add((Component)this.simpleRulesTextField, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            this.simpleRulesPanel.add((Component)this.simpleRulesAddButton, gridBagConstraints);
        }
        return this.simpleRulesPanel;
    }

    public JPanel getComplexRulesPanel() {
        if (this.complexRulesPanel == null) {
            this.complexRulesPanel = new JPanel(new GridBagLayout());
            this.complexRulesPanel.setBorder(BorderFactory.createEtchedBorder());
            this.complexRulesTree = new JTree();
            this.complexRulesScrollPane = new JScrollPane(this.complexRulesTree);
            this.complexRulesAndButton = new JButton(I18nUtils.getString("AND"));
            this.complexRulesOrButton = new JButton(I18nUtils.getString("OR"));
            this.complexRulesNotButton = new JButton(I18nUtils.getString("NOT"));
            this.complexRulesRemoveButton = new JButton(I18nUtils.getString("REMOVE_FIELD"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 4;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.complexRulesPanel.add((Component)this.complexRulesScrollPane, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            this.complexRulesPanel.add((Component)this.complexRulesAndButton, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.complexRulesPanel.add((Component)this.complexRulesOrButton, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.complexRulesPanel.add((Component)this.complexRulesNotButton, gridBagConstraints);
            gridBagConstraints.gridy = 3;
            this.complexRulesPanel.add((Component)this.complexRulesRemoveButton, gridBagConstraints);
        }
        return this.complexRulesPanel;
    }

    private JPanel getAdvancedSearchPanel() {
        if (this.advancedSearchPanel == null) {
            this.advancedSearchPanel = new JPanel(new GridBagLayout());
            this.advancedSearchPanel.setBorder(BorderFactory.createEtchedBorder());
            this.advancedSearchCheckBox = new JCheckBox(I18nUtils.getString("ENABLE_ADVANCED_SEARCH"));
            this.advancedSearchTextField = new CustomTextField();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.advancedSearchPanel.add((Component)this.advancedSearchCheckBox, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.advancedSearchPanel.add((Component)this.advancedSearchTextField, gridBagConstraints);
        }
        return this.advancedSearchPanel;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.searchButton = new JButton(I18nUtils.getString("SEARCH"));
            this.cancelButton = new JButton(I18nUtils.getString("CANCEL"));
            this.buttonsPanel.add(this.searchButton);
            this.buttonsPanel.add(this.cancelButton);
        }
        return this.buttonsPanel;
    }

    public static void main(String[] stringArray) {
        new CustomSearchDialog(null).setVisible(true);
    }

    public JComboBox getSearchAtComboBox() {
        return this.searchAtComboBox;
    }

    public JList getSimpleRulesList() {
        return this.simpleRulesList;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JComboBox getSimpleRulesComboBox() {
        return this.simpleRulesComboBox;
    }

    public JButton getSimpleRulesAddButton() {
        return this.simpleRulesAddButton;
    }

    public JTextField getSimpleRulesTextField() {
        return this.simpleRulesTextField;
    }

    public JTree getComplexRulesTree() {
        return this.complexRulesTree;
    }

    public JButton getComplexRulesAndButton() {
        return this.complexRulesAndButton;
    }

    public JButton getComplexRulesOrButton() {
        return this.complexRulesOrButton;
    }

    public JButton getComplexRulesNotButton() {
        return this.complexRulesNotButton;
    }

    public JTextField getAdvancedSearchTextField() {
        return this.advancedSearchTextField;
    }

    public JButton getComplexRulesRemoveButton() {
        return this.complexRulesRemoveButton;
    }

    public JCheckBox getAdvancedSearchCheckBox() {
        return this.advancedSearchCheckBox;
    }

    public JButton getSearchButton() {
        return this.searchButton;
    }
}

