/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalDialog;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumnSet;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class ColumnSetSelectorDialog
extends AbstractCustomModalDialog {
    private static final long serialVersionUID = -7592059207162524630L;
    private JTable columnsList;
    private ColumnsTableModel model;

    public ColumnSetSelectorDialog(JFrame jFrame) {
        super((Window)jFrame, 250, 300, true);
        this.setContent(this.getContent());
        this.setTitle(I18nUtils.getString("ARRANGE_COLUMNS"));
        this.setDefaultCloseOperation(2);
        GuiUtils.applyComponentOrientation(this);
    }

    public static void main(String[] stringArray) {
        new ColumnSetSelectorDialog(null).setVisible(true);
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.model = new ColumnsTableModel();
        this.columnsList = new JTable(this.model);
        this.columnsList.setShowGrid(false);
        this.columnsList.setTableHeader(null);
        this.columnsList.getColumnModel().getColumn(0).setMaxWidth(20);
        this.columnsList.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.columnsList.getSelectionModel().setSelectionMode(0);
        this.columnsList.setDefaultRenderer(String.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(GuiUtils.getComponentOrientationTableCellRendererCode()));
        JScrollPane jScrollPane = new JScrollPane(this.columnsList);
        JLabel jLabel = new JLabel(I18nUtils.getString("SELECT_COLUMNS"));
        JButton jButton = new JButton(I18nUtils.getString("OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnSetSelectorDialog.this.dispose();
            }
        });
        JButton jButton2 = new JButton(Images.getImage("go-up.png"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ColumnSetSelectorDialog.this.columnsList.getSelectedRow();
                if (n > 0) {
                    ColumnSetSelectorDialog.this.model.moveUp(n);
                }
            }
        });
        JButton jButton3 = new JButton(Images.getImage("go-down.png"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ColumnSetSelectorDialog.this.columnsList.getSelectedRow();
                if (n < ColumnSetSelectorDialog.this.columnsList.getModel().getRowCount() - 1) {
                    ColumnSetSelectorDialog.this.model.moveDown(n);
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 2;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        jPanel.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)jButton3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    public void setColumnSet(AbstractColumnSet abstractColumnSet) {
        this.model.setColumns(abstractColumnSet.getColumnsForSelection());
    }

    private class ColumnsTableModel
    implements TableModel {
        private static final long serialVersionUID = 5251001708812824836L;
        private List<AbstractColumn> columns;
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();

        ColumnsTableModel() {
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
            this.listeners.add(tableModelListener);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return n == 0 ? Boolean.class : String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            return "";
        }

        @Override
        public int getRowCount() {
            if (this.columns != null) {
                return this.columns.size();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.columns.get(n).isVisible();
            }
            return I18nUtils.getString(this.columns.get(n).getColumnName());
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void moveDown(int n) {
            AbstractColumn abstractColumn = this.columns.get(n);
            AbstractColumn abstractColumn2 = this.columns.get(n + 1);
            int n2 = abstractColumn.getOrder();
            abstractColumn.setOrder(abstractColumn2.getOrder());
            abstractColumn2.setOrder(n2);
            this.columns.remove(abstractColumn2);
            this.columns.add(n, abstractColumn2);
            TableModelEvent tableModelEvent = new TableModelEvent(this, -1, 0);
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).tableChanged(tableModelEvent);
            }
            ColumnSetSelectorDialog.this.columnsList.getColumnModel().getColumn(0).setMaxWidth(20);
            ColumnSetSelectorDialog.this.columnsList.getSelectionModel().setSelectionInterval(n + 1, n + 1);
        }

        public void moveUp(int n) {
            AbstractColumn abstractColumn = this.columns.get(n);
            AbstractColumn abstractColumn2 = this.columns.get(n - 1);
            int n2 = abstractColumn.getOrder();
            abstractColumn.setOrder(abstractColumn2.getOrder());
            abstractColumn2.setOrder(n2);
            this.columns.remove(abstractColumn2);
            this.columns.add(n, abstractColumn2);
            TableModelEvent tableModelEvent = new TableModelEvent(this, -1, 0);
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).tableChanged(tableModelEvent);
            }
            ColumnSetSelectorDialog.this.columnsList.getColumnModel().getColumn(0).setMaxWidth(20);
            ColumnSetSelectorDialog.this.columnsList.getSelectionModel().setSelectionInterval(n - 1, n - 1);
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.listeners.remove(tableModelListener);
        }

        public void setColumns(List<AbstractColumn> list) {
            this.columns = list;
            Collections.sort(this.columns);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.columns.get(n).setVisible((Boolean)object);
            }
        }
    }
}

