/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.controls;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.text.JTextComponent;
import net.sourceforge.atunes.misc.ClipboardFacade;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class EditionPopUpMenu
extends JPopupMenu {
    private static final long serialVersionUID = -3103254879422133063L;
    private JTextComponent textComponent;

    public EditionPopUpMenu(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        this.addPopUpMenu();
    }

    private void addPopUpMenu() {
        CutAction cutAction = new CutAction(this.textComponent);
        CopyAction copyAction = new CopyAction(this.textComponent);
        PasteAction pasteAction = new PasteAction(this.textComponent);
        DeleteAction deleteAction = new DeleteAction(this.textComponent);
        SelectAllAction selectAllAction = new SelectAllAction(this.textComponent);
        this.add(cutAction);
        this.add(copyAction);
        this.add(pasteAction);
        this.add(deleteAction);
        this.add(new JSeparator());
        this.add(selectAllAction);
        this.textComponent.addMouseListener(new TextComponentMouseAdapter(copyAction, deleteAction, selectAllAction, pasteAction, cutAction));
    }

    private static class SelectAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 9194366269589907916L;
        private JTextComponent textComponent;

        public SelectAllAction(JTextComponent jTextComponent) {
            super(I18nUtils.getString("SELECT_ALL"));
            this.textComponent = jTextComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.textComponent.setSelectionStart(0);
            this.textComponent.setSelectionEnd(this.textComponent.getText().length());
        }
    }

    private static class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 802324331526664365L;
        private JTextComponent textComponent;

        public DeleteAction(JTextComponent jTextComponent) {
            super(I18nUtils.getString("DELETE"));
            this.textComponent = jTextComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.textComponent.getText();
            String string2 = StringUtils.getString(string.substring(0, this.textComponent.getSelectionStart()), string.substring(this.textComponent.getSelectionEnd()));
            this.textComponent.setText(string2);
        }
    }

    private static class PasteAction
    extends AbstractAction {
        private static final long serialVersionUID = -7600198128040448381L;
        private JTextComponent textComponent;

        public PasteAction(JTextComponent jTextComponent) {
            super(I18nUtils.getString("PASTE"));
            this.textComponent = jTextComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.textComponent.getText();
            String string2 = ClipboardFacade.getClipboardContent();
            String string3 = StringUtils.getString(string.substring(0, this.textComponent.getSelectionStart()), string2, string.substring(this.textComponent.getSelectionEnd()));
            this.textComponent.setText(string3);
        }
    }

    private static class CopyAction
    extends AbstractAction {
        private static final long serialVersionUID = -2366530850960686780L;
        private JTextComponent textComponent;

        public CopyAction(JTextComponent jTextComponent) {
            super(I18nUtils.getString("COPY"));
            this.textComponent = jTextComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ClipboardFacade.copyToClipboard(this.textComponent.getSelectedText());
        }
    }

    private static class CutAction
    extends AbstractAction {
        private static final long serialVersionUID = -499875218309361915L;
        private JTextComponent textComponent;

        public CutAction(JTextComponent jTextComponent) {
            super(I18nUtils.getString("CUT"));
            this.textComponent = jTextComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.textComponent.getText();
            String string2 = string.substring(this.textComponent.getSelectionStart(), this.textComponent.getSelectionEnd());
            String string3 = StringUtils.getString(string.substring(0, this.textComponent.getSelectionStart()), string.substring(this.textComponent.getSelectionEnd()));
            ClipboardFacade.copyToClipboard(string2);
            this.textComponent.setText(string3);
        }
    }

    private final class TextComponentMouseAdapter
    extends MouseAdapter {
        private final Action copyAction;
        private final Action deleteAction;
        private final Action selectAllAction;
        private final Action pasteAction;
        private final Action cutAction;

        private TextComponentMouseAdapter(Action action, Action action2, Action action3, Action action4, Action action5) {
            this.copyAction = action;
            this.deleteAction = action2;
            this.selectAllAction = action3;
            this.pasteAction = action4;
            this.cutAction = action5;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            if (mouseEvent.getButton() == 3) {
                boolean bl = EditionPopUpMenu.this.textComponent.getSelectionStart() < EditionPopUpMenu.this.textComponent.getSelectionEnd();
                this.cutAction.setEnabled(bl && EditionPopUpMenu.this.textComponent.isEditable());
                this.deleteAction.setEnabled(bl && EditionPopUpMenu.this.textComponent.isEditable());
                this.copyAction.setEnabled(bl);
                this.pasteAction.setEnabled(ClipboardFacade.clipboardContainsText() && EditionPopUpMenu.this.textComponent.isEditable());
                this.selectAllAction.setEnabled(EditionPopUpMenu.this.textComponent.getText().length() > 0);
                EditionPopUpMenu.this.show(EditionPopUpMenu.this.textComponent, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

