/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.popup;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.border.Border;
import net.sourceforge.atunes.gui.WindowFader;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.utils.GuiUtils;

final class FadingPopup
extends Popup {
    private JWindow popupWindow = new JWindow();
    private WindowFader windowFader;

    FadingPopup(Component component, Component component2, int n, int n2, boolean bl) {
        Border border;
        this.popupWindow.setLocation(n, n2);
        this.popupWindow.getContentPane().add(component2, "Center");
        component2.invalidate();
        JComponent jComponent = (JComponent)component2.getParent();
        if (bl && (border = LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getShadowBorder()) != null) {
            jComponent.setBorder(border);
        }
        this.windowFader = new WindowFader(this.popupWindow, 40){

            @Override
            protected void fadeOutFinished() {
                FadingPopup.this.popupWindow.removeAll();
                super.fadeOutFinished();
            }
        };
    }

    @Override
    public void show() {
        GuiUtils.setWindowOpacity(this.popupWindow, 0.0f);
        this.popupWindow.setVisible(true);
        this.popupWindow.pack();
        GuiUtils.setWindowOpaque(this.popupWindow, false);
        this.windowFader.fadeIn();
    }

    @Override
    public void hide() {
        this.windowFader.fadeOut();
    }
}

