/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.utils.I18nUtils;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;

public final class RadioBrowserTreeTableModel
extends AbstractTreeTableModel {
    private static final long serialVersionUID = 1997644065009669746L;
    private Map<String, List<Radio>> radiosMap;
    private List<String> radioLabels;
    private static final String ROOT = "ROOT";

    public RadioBrowserTreeTableModel(List<Radio> list) {
        super((Object)new DefaultMutableTreeTableNode((Object)ROOT));
        this.setRadios(list);
    }

    private void setRadios(List<Radio> list) {
        this.radiosMap = new HashMap<String, List<Radio>>();
        this.radioLabels = new ArrayList<String>();
        for (Radio radio : list) {
            if (this.radiosMap.containsKey(radio.getLabel())) {
                this.radiosMap.get(radio.getLabel()).add(radio);
                continue;
            }
            ArrayList<Radio> arrayList = new ArrayList<Radio>();
            arrayList.add(radio);
            this.radiosMap.put(radio.getLabel(), arrayList);
            this.radioLabels.add(radio.getLabel());
        }
        Collections.sort(this.radioLabels);
    }

    private boolean isRoot(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
        return defaultMutableTreeTableNode.getUserObject().equals(ROOT);
    }

    private boolean isLabel(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
        return defaultMutableTreeTableNode.getUserObject() instanceof String;
    }

    public Object getChild(Object object, int n) {
        if (this.isRoot((DefaultMutableTreeTableNode)object)) {
            return new DefaultMutableTreeTableNode((Object)this.radioLabels.get(n));
        }
        if (this.isLabel((DefaultMutableTreeTableNode)object)) {
            String string = (String)((DefaultMutableTreeTableNode)object).getUserObject();
            return new DefaultMutableTreeTableNode((Object)this.radiosMap.get(string).get(n));
        }
        return "jj";
    }

    public int getChildCount(Object object) {
        if (this.isRoot((DefaultMutableTreeTableNode)object)) {
            return this.radioLabels.size();
        }
        if (this.isLabel((DefaultMutableTreeTableNode)object)) {
            String string = (String)((DefaultMutableTreeTableNode)object).getUserObject();
            return this.radiosMap.get(string).size();
        }
        return 0;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (this.isLabel((DefaultMutableTreeTableNode)object2)) {
            String string = (String)((DefaultMutableTreeTableNode)object2).getUserObject();
            return this.radioLabels.indexOf(string);
        }
        String string = (String)((DefaultMutableTreeTableNode)object).getUserObject();
        Radio radio = (Radio)((DefaultMutableTreeTableNode)object2).getUserObject();
        return this.radiosMap.get(string).indexOf(radio);
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return I18nUtils.getString("LABEL");
        }
        if (n == 1) {
            return I18nUtils.getString("NAME");
        }
        return I18nUtils.getString("URL");
    }

    public Object getValueAt(Object object, int n) {
        if (this.isLabel((DefaultMutableTreeTableNode)object)) {
            return n == 0 ? object : null;
        }
        Radio radio = (Radio)((DefaultMutableTreeTableNode)object).getUserObject();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return radio.getName();
        }
        if (n == 2) {
            return radio.getUrl();
        }
        return null;
    }
}

