/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.model;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTableCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.model.AbstractCommonTableModel;
import net.sourceforge.atunes.gui.model.NavigationTableModel;
import net.sourceforge.atunes.gui.renderers.ImageIconTableCellRendererCode;
import net.sourceforge.atunes.gui.renderers.IntegerTableCellRendererCode;
import net.sourceforge.atunes.gui.renderers.JLabelTableCellRendererCode;
import net.sourceforge.atunes.gui.renderers.PropertyTableCellRendererCode;
import net.sourceforge.atunes.gui.renderers.StringTableCellRendererCode;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumnSet;

public abstract class AbstractCommonColumnModel
extends DefaultTableColumnModel {
    private static final long serialVersionUID = -8202322203076350708L;
    private JTable table;
    private AbstractColumnSet columnSet;
    private AbstractCommonTableModel model;
    private int columnBeingMoved = -1;
    private int columnMovedTo = -1;
    private ColumnMoveListener columnMoveListener;
    private ColumnModelListener columnModelListener;

    public AbstractCommonColumnModel(JTable jTable, AbstractColumnSet abstractColumnSet) {
        this(jTable);
        this.columnSet = abstractColumnSet;
    }

    public AbstractCommonColumnModel(JTable jTable) {
        this.table = jTable;
        this.model = (AbstractCommonTableModel)this.table.getModel();
    }

    public final int getColumnIndexAtPosition(int n) {
        int n2 = n;
        if (n2 < 0) {
            return -1;
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if ((n2 -= this.getColumn(i).getPreferredWidth()) >= 0) continue;
            return i;
        }
        return -1;
    }

    protected final void updateColumnWidth() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            Class<? extends AbstractColumn> clazz = this.getColumnId(i);
            int n = this.getColumn(i).getPreferredWidth();
            this.setWidthForColumn(clazz, n);
        }
    }

    private final void setWidthForColumn(Class<? extends AbstractColumn> clazz, int n) {
        this.getColumn(clazz).setWidth(n);
    }

    public final void arrangeColumns(boolean bl) {
        this.setCurrentColumns();
        this.model.refresh(0);
        if (bl) {
            this.reapplyFilter();
        }
    }

    public final AbstractColumn getColumnObject(int n) {
        return this.getColumn(this.getColumnId(n));
    }

    private final Class<? extends AbstractColumn> getColumnId(int n) {
        return this.columnSet.getColumnId(n);
    }

    private final AbstractColumn getColumn(Class<? extends AbstractColumn> clazz) {
        return this.columnSet.getColumn(clazz);
    }

    public int getColumnAlignment(int n) {
        return this.getColumn(this.getColumnId(n)).getAlignment();
    }

    private void setCurrentColumns() {
        this.columnSet.setCurrentColumns();
    }

    private ColumnMoveListener getColumnMoveListener() {
        if (this.columnMoveListener == null) {
            this.columnMoveListener = new ColumnMoveListener();
        }
        return this.columnMoveListener;
    }

    private ColumnModelListener getColumnModelListener() {
        if (this.columnModelListener == null) {
            this.columnModelListener = new ColumnModelListener();
        }
        return this.columnModelListener;
    }

    public void enableColumnChange(boolean bl) {
        this.table.getTableHeader().setReorderingAllowed(bl);
        if (bl) {
            this.addColumnModelListener(this.getColumnModelListener());
            this.table.getTableHeader().addMouseListener(this.getColumnMoveListener());
        } else {
            this.removeColumnModelListener(this.getColumnModelListener());
            this.table.getTableHeader().removeMouseListener(this.getColumnMoveListener());
        }
    }

    protected abstract void reapplyFilter();

    protected void updateColumnSettings(TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer;
        AbstractColumn abstractColumn = this.getColumnObject(tableColumn.getModelIndex());
        tableColumn.setPreferredWidth(abstractColumn.getWidth());
        tableColumn.setWidth(abstractColumn.getWidth());
        tableColumn.setResizable(abstractColumn.isResizable());
        TableCellEditor tableCellEditor = abstractColumn.getCellEditor();
        if (tableCellEditor != null) {
            tableColumn.setCellEditor(tableCellEditor);
        }
        if ((tableCellRenderer = abstractColumn.getCellRenderer()) != null) {
            tableColumn.setCellRenderer(tableCellRenderer);
        }
    }

    protected void updateColumnHeader(TableColumn tableColumn) {
        AbstractColumn abstractColumn = this.getColumnObject(tableColumn.getModelIndex());
        if (abstractColumn.isSortable()) {
            tableColumn.setHeaderRenderer(LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableHeaderCellRenderer(new HeaderTableCellRendererCode(abstractColumn)));
        }
    }

    public AbstractColumnSet getColumnSet() {
        return this.columnSet;
    }

    public void setColumnSet(AbstractColumnSet abstractColumnSet) {
        this.columnSet = abstractColumnSet;
    }

    public AbstractTableCellRendererCode getRendererCodeFor(Class<?> clazz) {
        if (clazz.equals(Integer.class)) {
            return new IntegerTableCellRendererCode();
        }
        if (clazz.equals(ImageIcon.class)) {
            return new ImageIconTableCellRendererCode(this);
        }
        if (clazz.equals(String.class)) {
            return new StringTableCellRendererCode(this);
        }
        if (clazz.equals(JLabel.class)) {
            return new JLabelTableCellRendererCode(this);
        }
        if (clazz.equals(NavigationTableModel.Property.class)) {
            return new PropertyTableCellRendererCode();
        }
        return null;
    }

    protected JTable getTable() {
        return this.table;
    }

    private class ColumnModelListener
    implements TableColumnModelListener {
        private ColumnModelListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            AbstractCommonColumnModel.this.updateColumnWidth();
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            if (AbstractCommonColumnModel.this.columnBeingMoved == -1) {
                AbstractCommonColumnModel.this.columnBeingMoved = tableColumnModelEvent.getFromIndex();
            }
            AbstractCommonColumnModel.this.columnMovedTo = tableColumnModelEvent.getToIndex();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    private class ColumnMoveListener
    extends MouseAdapter {
        private ColumnMoveListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (AbstractCommonColumnModel.this.columnBeingMoved != -1) {
                if (AbstractCommonColumnModel.this.columnBeingMoved < AbstractCommonColumnModel.this.columnMovedTo) {
                    int n = AbstractCommonColumnModel.this.getColumnObject(AbstractCommonColumnModel.this.columnMovedTo).getOrder();
                    for (int i = AbstractCommonColumnModel.this.columnBeingMoved + 1; i <= AbstractCommonColumnModel.this.columnMovedTo; ++i) {
                        int n2 = AbstractCommonColumnModel.this.getColumnObject(i).getOrder();
                        AbstractCommonColumnModel.this.getColumnObject(i).setOrder(n2 - 1);
                    }
                    AbstractCommonColumnModel.this.getColumnObject(AbstractCommonColumnModel.this.columnBeingMoved).setOrder(n);
                } else if (AbstractCommonColumnModel.this.columnBeingMoved > AbstractCommonColumnModel.this.columnMovedTo) {
                    int n = AbstractCommonColumnModel.this.getColumnObject(AbstractCommonColumnModel.this.columnMovedTo).getOrder();
                    for (int i = AbstractCommonColumnModel.this.columnBeingMoved - 1; i >= AbstractCommonColumnModel.this.columnMovedTo; --i) {
                        int n3 = AbstractCommonColumnModel.this.getColumnObject(i).getOrder();
                        AbstractCommonColumnModel.this.getColumnObject(i).setOrder(n3 + 1);
                    }
                    AbstractCommonColumnModel.this.getColumnObject(AbstractCommonColumnModel.this.columnBeingMoved).setOrder(n);
                }
                AbstractCommonColumnModel.this.arrangeColumns(false);
            }
            AbstractCommonColumnModel.this.columnBeingMoved = -1;
            AbstractCommonColumnModel.this.columnMovedTo = -1;
        }
    }

    private static final class HeaderTableCellRendererCode
    extends AbstractTableCellRendererCode {
        private final AbstractColumn column;

        private HeaderTableCellRendererCode(AbstractColumn abstractColumn) {
            this.column = abstractColumn;
        }

        @Override
        public Component getComponent(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component2 = component;
            AbstractColumn.ColumnSort columnSort = this.column.getColumnSort();
            if (columnSort != null) {
                ((JLabel)component2).setHorizontalTextPosition(2);
                if (columnSort.equals((Object)AbstractColumn.ColumnSort.ASCENDING)) {
                    ((JLabel)component2).setIcon(Images.getImage("arrowUp.png"));
                } else if (columnSort.equals((Object)AbstractColumn.ColumnSort.DESCENDING)) {
                    ((JLabel)component2).setIcon(Images.getImage("arrowDown.png"));
                }
            }
            return component2;
        }
    }
}

