/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.lookandfeel.substance;

import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import net.sourceforge.atunes.gui.lookandfeel.AbstractListCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.AbstractLookAndFeel;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTableCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTreeCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.substance.CircleButtonShaper;
import net.sourceforge.atunes.gui.lookandfeel.substance.LeftConcaveButtonShaper;
import net.sourceforge.atunes.gui.lookandfeel.substance.RightConcaveButtonShaper;
import net.sourceforge.atunes.gui.lookandfeel.substance.RoundRectButtonShaper;
import net.sourceforge.atunes.gui.views.controls.playerControls.MuteButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.NextButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.PlayPauseButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.PreviousButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.SecondaryControl;
import net.sourceforge.atunes.gui.views.controls.playerControls.StopButton;
import net.sourceforge.atunes.gui.views.panels.PlayerControlsPanel;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.GuiUtils;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.utils.ShadowPopupBorder;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.fonts.FontPolicy;
import org.pushingpixels.substance.api.fonts.FontSet;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableHeaderCellRenderer;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTreeCellRenderer;

public final class SubstanceLookAndFeel
extends AbstractLookAndFeel {
    private static Map<String, String> skins = SubstanceLookAndFeel.setMapOfSkins();
    private static final String DEFAULT_SKIN = "aTunes Blue";

    private static Map<String, String> setMapOfSkins() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BusinessBlackSteel", "org.pushingpixels.substance.api.skin.SubstanceBusinessBlackSteelLookAndFeel");
        hashMap.put("Creme", "org.pushingpixels.substance.api.skin.SubstanceCremeLookAndFeel");
        hashMap.put("Business", "org.pushingpixels.substance.api.skin.SubstanceBusinessLookAndFeel");
        hashMap.put("BusinessBlueSteel", "org.pushingpixels.substance.api.skin.SubstanceBusinessBlueSteelLookAndFeel");
        hashMap.put("CremeCoffee", "org.pushingpixels.substance.api.skin.SubstanceCremeCoffeeLookAndFeel");
        hashMap.put("Sahara", "org.pushingpixels.substance.api.skin.SubstanceSaharaLookAndFeel");
        hashMap.put("Moderate", "org.pushingpixels.substance.api.skin.SubstanceModerateLookAndFeel");
        hashMap.put("OfficeSilver2007", "org.pushingpixels.substance.api.skin.SubstanceOfficeSilver2007LookAndFeel");
        hashMap.put("Nebula", "org.pushingpixels.substance.api.skin.SubstanceNebulaLookAndFeel");
        hashMap.put("NebulaBrickWall", "org.pushingpixels.substance.api.skin.SubstanceNebulaBrickWallLookAndFeel");
        hashMap.put("Autumn", "org.pushingpixels.substance.api.skin.SubstanceAutumnLookAndFeel");
        hashMap.put("MistSilver", "org.pushingpixels.substance.api.skin.SubstanceMistSilverLookAndFeel");
        hashMap.put("MistAqua", "org.pushingpixels.substance.api.skin.SubstanceMistAquaLookAndFeel");
        hashMap.put("DustCoffee", "org.pushingpixels.substance.api.skin.SubstanceDustCoffeeLookAndFeel");
        hashMap.put("Dust", "org.pushingpixels.substance.api.skin.SubstanceDustLookAndFeel");
        hashMap.put("Raven", "org.pushingpixels.substance.api.skin.SubstanceRavenLookAndFeel");
        hashMap.put("ChallengerDeep", "org.pushingpixels.substance.api.skin.SubstanceChallengerDeepLookAndFeel");
        hashMap.put("EmeraldDusk", "org.pushingpixels.substance.api.skin.SubstanceEmeraldDuskLookAndFeel");
        hashMap.put("Twilight", "org.pushingpixels.substance.api.skin.SubstanceTwilightLookAndFeel");
        hashMap.put("OfficeBlue2007", "org.pushingpixels.substance.api.skin.SubstanceOfficeBlue2007LookAndFeel");
        hashMap.put("Gemini", "org.pushingpixels.substance.api.skin.SubstanceGeminiLookAndFeel");
        hashMap.put("Magellan", "org.pushingpixels.substance.api.skin.SubstanceMagellanLookAndFeel");
        hashMap.put("GraphiteAqua", "org.pushingpixels.substance.api.skin.SubstanceGraphiteAquaLookAndFeel");
        hashMap.put("GraphiteGlass", "org.pushingpixels.substance.api.skin.SubstanceGraphiteGlassLookAndFeel");
        hashMap.put("Graphite", "org.pushingpixels.substance.api.skin.SubstanceGraphiteLookAndFeel");
        hashMap.put(DEFAULT_SKIN, "net.sourceforge.atunes.gui.lookandfeel.substance.SubstanceATunesBlueLookAndFeel");
        hashMap.put("aTunes Dark", "net.sourceforge.atunes.gui.lookandfeel.substance.SubstanceATunesDarkLookAndFeel");
        hashMap.put("aTunes Gray", "net.sourceforge.atunes.gui.lookandfeel.substance.SubstanceATunesGrayLookAndFeel");
        return hashMap;
    }

    @Override
    public String getName() {
        return "Substance";
    }

    @Override
    public String getDescription() {
        return "Substance Look And Feel";
    }

    @Override
    public void initializeLookAndFeel() {
        AnimationConfigurationManager.getInstance().setTimelineDuration(0L);
        UIManager.put("substancelaf.tabbedPaneContentBorderKind", SubstanceConstants.TabContentPaneBorderKind.SINGLE_FULL);
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
    }

    @Override
    public void setLookAndFeel(String string) {
        try {
            if (skins.containsKey(string)) {
                UIManager.setLookAndFeel(skins.get(string));
            } else {
                UIManager.setLookAndFeel(skins.get(DEFAULT_SKIN));
            }
            GuiUtils.setBorderColor(org.pushingpixels.substance.api.SubstanceLookAndFeel.getCurrentSkin().getActiveColorScheme(DecorationAreaType.GENERAL).getMidColor());
        }
        catch (ClassNotFoundException classNotFoundException) {
            new Logger().internalError(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            new Logger().internalError(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            new Logger().internalError(illegalAccessException);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            new Logger().internalError(unsupportedLookAndFeelException);
        }
    }

    @Override
    public String getDefaultSkin() {
        return DEFAULT_SKIN;
    }

    @Override
    public List<String> getSkins() {
        ArrayList<String> arrayList = new ArrayList<String>(skins.keySet());
        Collections.sort(arrayList, new SkinsComparator());
        return arrayList;
    }

    @Override
    public TreeCellRenderer getTreeCellRenderer(AbstractTreeCellRendererCode abstractTreeCellRendererCode) {
        return new SubstanceLookAndFeelTreeCellRenderer(abstractTreeCellRendererCode);
    }

    @Override
    public TableCellRenderer getTableCellRenderer(AbstractTableCellRendererCode abstractTableCellRendererCode) {
        return new SubstanceLookAndFeelTableCellRenderer(abstractTableCellRendererCode);
    }

    @Override
    public TableCellRenderer getTableHeaderCellRenderer(AbstractTableCellRendererCode abstractTableCellRendererCode) {
        return new SubstanceLookAndFeelTableHeaderCellRenderer(abstractTableCellRendererCode);
    }

    @Override
    public ListCellRenderer getListCellRenderer(AbstractListCellRendererCode abstractListCellRendererCode) {
        return new SubstanceLookAndFeelListCellRenderer(abstractListCellRendererCode);
    }

    @Override
    public boolean isDialogUndecorated() {
        return true;
    }

    @Override
    public void putClientProperties(JComponent jComponent) {
        if (jComponent instanceof SecondaryControl || jComponent instanceof MuteButton || jComponent instanceof StopButton) {
            jComponent.putClientProperty("substancelaf.buttonShaper", new RoundRectButtonShaper());
        } else if (jComponent instanceof NextButton) {
            jComponent.putClientProperty("substancelaf.buttonShaper", GuiUtils.getComponentOrientation().isLeftToRight() ? new LeftConcaveButtonShaper(PlayerControlsPanel.PLAY_BUTTON_SIZE.height) : new RightConcaveButtonShaper(PlayerControlsPanel.PLAY_BUTTON_SIZE.height));
        } else if (jComponent instanceof PlayPauseButton) {
            jComponent.putClientProperty("substancelaf.buttonShaper", new CircleButtonShaper());
        } else if (jComponent instanceof PreviousButton) {
            jComponent.putClientProperty("substancelaf.buttonShaper", GuiUtils.getComponentOrientation().isLeftToRight() ? new RightConcaveButtonShaper(PlayerControlsPanel.PLAY_BUTTON_SIZE.height) : new LeftConcaveButtonShaper(PlayerControlsPanel.PLAY_BUTTON_SIZE.height));
        }
    }

    @Override
    public boolean isCustomPlayerControlsSupported() {
        return true;
    }

    @Override
    public Border getShadowBorder() {
        return ShadowPopupBorder.getInstance();
    }

    @Override
    public void initializeFonts(Font font) {
        org.pushingpixels.substance.api.SubstanceLookAndFeel.setFontPolicy((FontPolicy)new CustomFontPolicy(font));
    }

    @Override
    public Font getDefaultFont() {
        return org.pushingpixels.substance.api.SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null).getControlFont();
    }

    private static final class SkinsComparator
    implements Comparator<String> {
        private SkinsComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            return string.toLowerCase().compareTo(string2.toLowerCase());
        }
    }

    private static final class SubstanceLookAndFeelTreeCellRenderer
    extends SubstanceDefaultTreeCellRenderer {
        private final AbstractTreeCellRendererCode code;
        private static final long serialVersionUID = 3830003466764008228L;

        private SubstanceLookAndFeelTreeCellRenderer(AbstractTreeCellRendererCode abstractTreeCellRendererCode) {
            this.code = abstractTreeCellRendererCode;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            return this.code.getComponent(component, jTree, object, bl, bl2, bl3, n, bl4);
        }
    }

    private static final class SubstanceLookAndFeelTableCellRenderer
    extends SubstanceDefaultTableCellRenderer {
        private final AbstractTableCellRendererCode code;
        private static final long serialVersionUID = 2844251523912028654L;

        private SubstanceLookAndFeelTableCellRenderer(AbstractTableCellRendererCode abstractTableCellRendererCode) {
            this.code = abstractTableCellRendererCode;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this.code.getComponent(component, jTable, object, bl, bl2, n, n2);
        }
    }

    private static final class SubstanceLookAndFeelTableHeaderCellRenderer
    extends SubstanceDefaultTableHeaderCellRenderer {
        private final AbstractTableCellRendererCode code;
        private static final long serialVersionUID = 1L;

        private SubstanceLookAndFeelTableHeaderCellRenderer(AbstractTableCellRendererCode abstractTableCellRendererCode) {
            this.code = abstractTableCellRendererCode;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this.code.getComponent(component, jTable, object, bl, bl2, n, n2);
        }
    }

    private static final class SubstanceLookAndFeelListCellRenderer
    extends SubstanceDefaultListCellRenderer {
        private final AbstractListCellRendererCode code;
        private static final long serialVersionUID = 2572603555660744197L;

        private SubstanceLookAndFeelListCellRenderer(AbstractListCellRendererCode abstractListCellRendererCode) {
            this.code = abstractListCellRendererCode;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
            return this.code.getComponent(component, jList, object, n, bl, bl2);
        }
    }

    private static final class CustomFontPolicy
    implements FontPolicy {
        private final Font baseFont;

        private CustomFontPolicy(Font font) {
            this.baseFont = font;
        }

        public FontSet getFontSet(String string, UIDefaults uIDefaults) {
            return new CustomFontSet();
        }

        private final class CustomFontSet
        implements FontSet {
            private FontUIResource windowTitleFont;
            private FontUIResource titleFont;
            private FontUIResource smallFont;
            private FontUIResource messageFont;
            private FontUIResource menuFont;
            private FontUIResource controlFont;

            private CustomFontSet() {
                this.windowTitleFont = new FontUIResource(CustomFontPolicy.this.baseFont.deriveFont(1, (float)CustomFontPolicy.this.baseFont.getSize() + 1.0f));
                this.titleFont = new FontUIResource(CustomFontPolicy.this.baseFont.deriveFont((float)CustomFontPolicy.this.baseFont.getSize()));
                this.smallFont = new FontUIResource(CustomFontPolicy.this.baseFont.deriveFont((float)CustomFontPolicy.this.baseFont.getSize() - 1.0f));
                this.messageFont = new FontUIResource(CustomFontPolicy.this.baseFont.deriveFont((float)CustomFontPolicy.this.baseFont.getSize() - 1.0f));
                this.menuFont = new FontUIResource(CustomFontPolicy.this.baseFont.deriveFont((float)CustomFontPolicy.this.baseFont.getSize()));
                this.controlFont = new FontUIResource(CustomFontPolicy.this.baseFont.deriveFont((float)CustomFontPolicy.this.baseFont.getSize()));
            }

            public FontUIResource getWindowTitleFont() {
                return this.windowTitleFont;
            }

            public FontUIResource getTitleFont() {
                return this.titleFont;
            }

            public FontUIResource getSmallFont() {
                return this.smallFont;
            }

            public FontUIResource getMessageFont() {
                return this.messageFont;
            }

            public FontUIResource getMenuFont() {
                return this.menuFont;
            }

            public FontUIResource getControlFont() {
                return this.controlFont;
            }
        }
    }
}

