/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.lookandfeel.substance;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.border.Border;
import org.pushingpixels.substance.api.shaper.StandardButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.utils.border.SubstanceButtonBorder;

public abstract class AbstractButtonShaper
implements SubstanceButtonShaper {
    public Dimension getPreferredSize(AbstractButton abstractButton, Dimension dimension) {
        if (abstractButton.getClientProperty("substancelaf.buttonbordercomputed") == null) {
            boolean bl = abstractButton.getClientProperty("substancelaf.buttonbordercomputing") != null;
            Border border = abstractButton.getBorder();
            int n = dimension.width;
            int n2 = dimension.height;
            Insets insets = border.getBorderInsets(abstractButton);
            if (!bl) {
                abstractButton.setBorder(null);
            }
            dimension.setSize(n - insets.left - insets.right, n2 - insets.top - insets.bottom);
            if (!bl) {
                abstractButton.setBorder(this.getButtonBorder(abstractButton));
                abstractButton.putClientProperty("substancelaf.buttonbordercomputed", "");
            }
        }
        return dimension;
    }

    public Border getButtonBorder(AbstractButton abstractButton) {
        return new CustomSubstanceButtonBorder(StandardButtonShaper.class);
    }

    public boolean isProportionate() {
        return true;
    }

    private static final class CustomSubstanceButtonBorder
    extends SubstanceButtonBorder {
        private CustomSubstanceButtonBorder(Class<?> clazz) {
            super(clazz);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }
    }
}

