/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.autocomplete;

import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public final class AutoCompleteDocument
extends PlainDocument {
    private static final long serialVersionUID = -4353609211147483101L;
    private boolean selecting = false;
    private boolean strictMatching;
    private AbstractAutoCompleteAdaptor adaptor;
    private ObjectToStringConverter stringConverter;

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor abstractAutoCompleteAdaptor, boolean bl, ObjectToStringConverter objectToStringConverter) {
        this.adaptor = abstractAutoCompleteAdaptor;
        this.strictMatching = bl;
        this.stringConverter = objectToStringConverter;
        Object object = abstractAutoCompleteAdaptor.getSelectedItem();
        if (object != null) {
            this.setText(objectToStringConverter.getPreferredStringForItem(object));
        }
        abstractAutoCompleteAdaptor.markEntireText();
    }

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor abstractAutoCompleteAdaptor, boolean bl) {
        this(abstractAutoCompleteAdaptor, bl, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public boolean isStrictMatching() {
        return this.strictMatching;
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.remove(n, n2);
        if (!this.strictMatching) {
            this.setSelectedItem(this.getText(0, this.getLength()), this.getText(0, this.getLength()));
            this.adaptor.getTextComponent().setCaretPosition(n);
        }
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        int n2 = n;
        if (this.selecting) {
            return;
        }
        super.insertString(n2, string, attributeSet);
        LookupResult lookupResult = this.lookupItem(this.getText(0, this.getLength()));
        if (lookupResult.matchingItem != null) {
            this.setSelectedItem(lookupResult.matchingItem, lookupResult.matchingString);
        } else if (this.strictMatching) {
            lookupResult.matchingItem = this.adaptor.getSelectedItem();
            lookupResult.matchingString = this.adaptor.getSelectedItemAsString();
            n2 -= string.length();
            UIManager.getLookAndFeel().provideErrorFeedback(this.adaptor.getTextComponent());
        } else {
            lookupResult.matchingItem = this.getText(0, this.getLength());
            lookupResult.matchingString = this.getText(0, this.getLength());
            this.setSelectedItem(lookupResult.matchingItem, lookupResult.matchingString);
        }
        this.setText(lookupResult.matchingString);
        this.adaptor.markText(n2 + string.length());
    }

    private void setText(String string) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalArgumentException(badLocationException);
        }
    }

    private void setSelectedItem(Object object, String string) {
        this.selecting = true;
        this.adaptor.setSelectedItem(object);
        this.adaptor.setSelectedItemAsString(string);
        this.selecting = false;
    }

    private LookupResult lookupItem(String string) {
        LookupResult lookupResult = this.findMatch(string, true);
        if (lookupResult != null) {
            return lookupResult;
        }
        Object object = this.adaptor.getSelectedItem();
        String[] stringArray = this.stringConverter.getPossibleStringsForItem(object);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!this.startsWith(string2, string)) continue;
                return new LookupResult(object, string2);
            }
        }
        if ((lookupResult = this.findMatch(string, false)) != null) {
            return lookupResult;
        }
        return new LookupResult(null, "");
    }

    private LookupResult findMatch(String string, boolean bl) {
        int n = this.adaptor.getItemCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.adaptor.getItem(i);
            String[] stringArray = this.stringConverter.getPossibleStringsForItem(object);
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                if ((!bl || !string2.equals(string)) && (bl || !this.startsWith(string2, string))) continue;
                return new LookupResult(object, string2);
            }
        }
        return null;
    }

    private boolean startsWith(String string, String string2) {
        if (string.length() < string2.length()) {
            return false;
        }
        return string.regionMatches(false, 0, string2, 0, string2.length());
    }

    private static class LookupResult {
        private Object matchingItem;
        private String matchingString;

        protected LookupResult(Object object, String string) {
            this.matchingItem = object;
            this.matchingString = string;
        }
    }
}

