/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.interfaces;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import org.gstreamer.GObject;
import org.gstreamer.interfaces.Tuner;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.GstTunerAPI;
import org.gstreamer.lowlevel.NativeObject;

public class TunerChannel
extends GObject {
    private final GstTunerAPI.TunerChannelStruct struct;
    private final Tuner tuner;

    public TunerChannel(NativeObject.Initializer init) {
        super(init);
        throw new IllegalArgumentException("Cannot instantiate");
    }

    TunerChannel(Tuner tuner, Pointer ptr, boolean needRef, boolean ownsHandle) {
        super(TunerChannel.initializer(ptr, needRef, ownsHandle));
        this.struct = new GstTunerAPI.TunerChannelStruct(ptr);
        this.tuner = tuner;
    }

    public final boolean hasFlag(int flag) {
        return (this.struct.getFlags() & flag) != 0;
    }

    public long getFrequency() {
        return GstTunerAPI.GSTTUNER_API.gst_tuner_get_frequency(this.tuner, this).longValue();
    }

    public void setFrequency(long frequency) {
        GstTunerAPI.GSTTUNER_API.gst_tuner_set_frequency(this.tuner, this, new NativeLong(frequency));
    }

    public boolean isTuningChannel() {
        return this.hasFlag(4);
    }

    public int getSignalStrength() {
        return GstTunerAPI.GSTTUNER_API.gst_tuner_signal_strength(this.tuner, this);
    }

    public void connect(final FREQUENCY_CHANGED listener) {
        this.connect(FREQUENCY_CHANGED.class, listener, new GstAPI.GstCallback(){

            public boolean callback(Pointer unused, long frequency, Pointer user_data) {
                listener.frequencyChanged(TunerChannel.this, frequency);
                return true;
            }
        });
    }

    public void disconnect(FREQUENCY_CHANGED listener) {
        super.disconnect(FREQUENCY_CHANGED.class, listener);
    }

    public void connect(final SIGNAL_CHANGED listener) {
        this.connect(SIGNAL_CHANGED.class, listener, new GstAPI.GstCallback(){

            public boolean callback(Pointer unused, int signal, Pointer user_data) {
                listener.signalChanged(TunerChannel.this, signal);
                return true;
            }
        });
    }

    public void disconnect(SIGNAL_CHANGED listener) {
        super.disconnect(SIGNAL_CHANGED.class, listener);
    }

    public static interface SIGNAL_CHANGED {
        public void signalChanged(TunerChannel var1, int var2);
    }

    public static interface FREQUENCY_CHANGED {
        public void frequencyChanged(TunerChannel var1, long var2);
    }

    public static final class Flags {
        public static final int INPUT = 1;
        public static final int OUTPUT = 2;
        public static final int FREQUENCY = 4;
        public static final int AUDIO = 8;
    }
}

