/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.Pipeline;
import org.gstreamer.elements.PlayBin;
import org.gstreamer.swing.VideoPlayer;

public class PiPDemo {
    public static void main(String[] args) {
        if ((args = Gst.init("Swing Player", args)).length < 1) {
            System.err.println("Usage: SwingPlayer <filename>");
            System.exit(1);
        }
        final String[] files = args;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame("Swing Video Player");
                JLayeredPane layeredPane = new JLayeredPane();
                frame.add((Component)layeredPane, "Center");
                final VideoPlayer full = new VideoPlayer(files[0]);
                full.setPreferredSize(new Dimension(1024, 768));
                full.setControlsVisible(true);
                full.setBounds(0, 0, 640, 480);
                full.getMediaPlayer().play();
                layeredPane.add((Component)full, JLayeredPane.DEFAULT_LAYER);
                layeredPane.setPreferredSize(new Dimension(640, 480));
                final JPanel pip = new JPanel();
                pip.setOpaque(false);
                pip.setBackground(new Color(0, 0, 0, 0));
                layeredPane.add((Component)pip, new Integer(1));
                pip.setBounds(0, 0, 640, 480);
                pip.setLayout(new FlowLayout());
                final JPanel controls = new JPanel();
                controls.setBounds(full.getBounds());
                controls.setLayout(new BorderLayout());
                layeredPane.add((Component)controls, (Object)2);
                JPanel buttonPanel = new JPanel();
                buttonPanel.setLayout(new BorderLayout());
                JButton quit = new JButton("Quit");
                buttonPanel.add((Component)quit, "West");
                quit.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        System.exit(0);
                    }
                });
                quit.setOpaque(false);
                controls.add((Component)buttonPanel, "North");
                controls.setOpaque(false);
                buttonPanel.setOpaque(false);
                layeredPane.addComponentListener(new ComponentAdapter(){

                    public void componentResized(ComponentEvent e) {
                        JComponent c = (JComponent)e.getComponent();
                        Rectangle r = c.getBounds();
                        full.setBounds(r);
                        pip.setBounds(r);
                        controls.setBounds(r);
                        c.revalidate();
                    }
                });
                for (int i = 1; i < files.length; ++i) {
                    String uri = files[i];
                    final VideoPlayer player = new VideoPlayer(uri);
                    player.setPreferredSize(new Dimension(200, 150));
                    player.setOpacity(0.4f);
                    player.setOpaque(false);
                    player.setControlsVisible(false);
                    Pipeline pipe = player.getMediaPlayer().getPipeline();
                    if (pipe instanceof PlayBin) {
                        ((PlayBin)pipe).setAudioSink(ElementFactory.make("fakesink", "audio"));
                    }
                    pip.add(player);
                    Timer timer = new Timer(1000 * i, new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            player.getMediaPlayer().play();
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
                frame.setDefaultCloseOperation(3);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }
}

