/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.Event;
import org.gstreamer.GObject;
import org.gstreamer.GstObject;
import org.gstreamer.MiniObject;
import org.gstreamer.PadDirection;
import org.gstreamer.PadLinkReturn;
import org.gstreamer.PadTemplate;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstPadAPI;
import org.gstreamer.lowlevel.NativeObject;
import org.gstreamer.lowlevel.annotations.CallerOwnsReturn;

public class Pad
extends GstObject {
    private static final API gst = GstNative.load(API.class);

    public Pad(NativeObject.Initializer init) {
        super(init);
    }

    public Pad(String name, PadDirection direction) {
        this(Pad.initializer(gst.ptr_gst_pad_new(name, direction)));
    }

    public Pad(PadTemplate template, String name) {
        this(Pad.initializer(gst.ptr_gst_pad_new_from_template(template, name)));
    }

    public Caps getCaps() {
        return gst.gst_pad_get_caps(this);
    }

    public boolean setCaps(Caps caps) {
        return gst.gst_pad_set_caps(this, caps);
    }

    public Caps getAllowedCaps() {
        return gst.gst_pad_get_allowed_caps(this);
    }

    public Caps getNegotiatedCaps() {
        return gst.gst_pad_get_negotiated_caps(this);
    }

    public Pad getPeer() {
        return gst.gst_pad_get_peer(this);
    }

    public Caps getPeerCaps() {
        return gst.gst_pad_peer_get_caps(this);
    }

    public boolean acceptCaps(Caps caps) {
        return gst.gst_pad_accept_caps(this, caps);
    }

    public boolean peerAcceptCaps(Caps caps) {
        return gst.gst_pad_peer_accept_caps(this, caps);
    }

    public PadLinkReturn link(Pad pad) {
        return gst.gst_pad_link(this, pad);
    }

    public boolean unlink(Pad pad) {
        return gst.gst_pad_unlink(this, pad);
    }

    public boolean isLinked() {
        return gst.gst_pad_is_linked(this);
    }

    public PadDirection getDirection() {
        return gst.gst_pad_get_direction(this);
    }

    public Element getParentElement() {
        return gst.gst_pad_get_parent_element(this);
    }

    public boolean setActive(boolean active) {
        return gst.gst_pad_set_active(this, active);
    }

    public boolean setBlocked(boolean blocked) {
        return gst.gst_pad_set_blocked(this, blocked);
    }

    public boolean isBlocked() {
        return gst.gst_pad_is_blocked(this);
    }

    public boolean setBlockedAsync(boolean blocked, GstPadAPI.PadBlockCallback callback) {
        return gst.gst_pad_set_blocked_async(this, blocked, callback, null);
    }

    public boolean isBlocking() {
        return gst.gst_pad_is_blocking(this);
    }

    public void connect(final HAVE_DATA listener) {
        this.connect(HAVE_DATA.class, listener, new GstAPI.GstCallback(){

            public boolean callback(Pad pad, Buffer buffer) {
                listener.haveData(pad, buffer);
                return true;
            }
        });
    }

    public void disconnect(HAVE_DATA listener) {
        this.disconnect(HAVE_DATA.class, listener);
    }

    public void connect(final LINKED listener) {
        this.connect(LINKED.class, listener, new GstAPI.GstCallback(){

            public boolean callback(Pad pad, Pad peer, Pointer user_data) {
                listener.linked(pad, peer);
                return true;
            }
        });
    }

    public void disconnect(LINKED listener) {
        this.disconnect(LINKED.class, listener);
    }

    public void connect(final UNLINKED listener) {
        this.connect(UNLINKED.class, listener, new GstAPI.GstCallback(){

            public boolean callback(Pad pad, Pad peer, Pointer user_data) {
                listener.unlinked(pad, peer);
                return true;
            }
        });
    }

    public void disconnect(UNLINKED listener) {
        this.disconnect(UNLINKED.class, listener);
    }

    public void connect(final REQUEST_LINK listener) {
        this.connect(REQUEST_LINK.class, listener, new GstAPI.GstCallback(){

            public boolean callback(Pad pad, Pad peer, Pointer user_daa) {
                listener.requestLink(pad, peer);
                return true;
            }
        });
    }

    public void disconnect(REQUEST_LINK listener) {
        this.disconnect(REQUEST_LINK.class, listener);
    }

    public void addEventProbe(final EVENT_PROBE listener) {
        GstPadAPI.PadEventProbe probe = new GstPadAPI.PadEventProbe(){

            public boolean callback(Pad pad, Event ev, Pointer unused) {
                return !listener.eventReceived(pad, ev);
            }
        };
        GObject.GCallback cb = new GObject.GCallback(gst.gst_pad_add_event_probe(this, probe, null), (Callback)probe){

            protected void disconnect() {
                gst.gst_pad_remove_event_probe(Pad.this, this.id);
            }
        };
        this.addCallback(EVENT_PROBE.class, listener, cb);
    }

    public void removeEventProbe(EVENT_PROBE listener) {
        this.removeCallback(EVENT_PROBE.class, listener);
    }

    public boolean sendEvent(Event event) {
        return gst.gst_pad_send_event(this, event);
    }

    public boolean pushEvent(Event event) {
        return gst.gst_pad_push_event(this, event);
    }

    public static interface EVENT_PROBE {
        public boolean eventReceived(Pad var1, Event var2);
    }

    public static interface REQUEST_LINK {
        public void requestLink(Pad var1, Pad var2);
    }

    public static interface UNLINKED {
        public void unlinked(Pad var1, Pad var2);
    }

    public static interface LINKED {
        public void linked(Pad var1, Pad var2);
    }

    public static interface HAVE_DATA {
        public void haveData(Pad var1, MiniObject var2);
    }

    private static interface API
    extends GstPadAPI {
        @CallerOwnsReturn
        public Pointer ptr_gst_pad_new(String var1, PadDirection var2);

        @CallerOwnsReturn
        public Pointer ptr_gst_pad_new_from_template(PadTemplate var1, String var2);
    }
}

