/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import java.util.HashMap;
import java.util.Map;
import org.gstreamer.lowlevel.EnumMapper;
import org.gstreamer.lowlevel.GstMessageAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.IntegerEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MessageType implements IntegerEnum
{
    UNKNOWN(0),
    EOS(1),
    ERROR(2),
    WARNING(4),
    INFO(8),
    TAG(16),
    BUFFERING(32),
    STATE_CHANGED(64),
    STATE_DIRTY(128),
    STEP_DONE(256),
    CLOCK_PROVIDE(512),
    CLOCK_LOST(1024),
    NEW_CLOCK(2048),
    STRUCTURE_CHANGE(4096),
    STREAM_STATUS(8192),
    APPLICATION(16384),
    ELEMENT(32768),
    SEGMENT_START(65536),
    SEGMENT_DONE(131072),
    DURATION(262144),
    LATENCY(524288),
    ASYNC_START(0x100000),
    ASYNC_DONE(0x200000),
    ANY(-1);

    private final int type;
    private final String name;

    private MessageType(int type) {
        this.type = type;
        GstMessageAPI messageAPI = GstNative.load(GstMessageAPI.class);
        this.name = messageAPI.gst_message_type_get_name(this);
    }

    @Override
    public int intValue() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public static final MessageType valueOf(int type) {
        return EnumMapper.getInstance().valueOf(type, MessageType.class);
    }

    public static final MessageType forName(String name) {
        MessageType type = (MessageType)MapHolder.typeMap.get(name);
        return type != null ? type : UNKNOWN;
    }

    private static final class MapHolder {
        private static final Map<String, MessageType> typeMap = new HashMap<String, MessageType>();

        private MapHolder() {
        }

        static {
            for (MessageType t : MessageType.values()) {
                typeMap.put(t.getName(), t);
            }
        }
    }
}

