/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Pointer;
import java.util.EventListener;
import java.util.EventListenerProxy;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gstreamer.GObject;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstObjectAPI;
import org.gstreamer.lowlevel.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GstObject
extends GObject {
    private static final GstObjectAPI gst = GstNative.load(GstObjectAPI.class);
    private static Logger logger = Logger.getLogger(GstObject.class.getName());
    static Level DEBUG = Level.FINE;
    static Level LIFECYCLE = NativeObject.LIFECYCLE;
    private Map<Class<? extends EventListener>, Map<EventListener, EventListenerProxy>> listenerMap;

    public GstObject(NativeObject.Initializer init) {
        super(init);
        if (init.ownsHandle && init.needRef) {
            this.sink();
        }
    }

    protected static NativeObject.Initializer initializer(Pointer ptr) {
        return GstObject.initializer(ptr, true, true);
    }

    protected static NativeObject.Initializer initializer(Pointer ptr, boolean needRef) {
        return GstObject.initializer(ptr, needRef, true);
    }

    protected static NativeObject.Initializer steal(GstObject victim) {
        NativeObject.Initializer init = new NativeObject.Initializer(victim.handle(), false, true);
        victim.invalidate();
        return init;
    }

    public boolean setName(String name) {
        logger.entering("GstObject", "setName", name);
        return gst.gst_object_set_name(this, name);
    }

    public String getName() {
        logger.entering("GstObject", "getName");
        return gst.gst_object_get_name(this);
    }

    @Override
    public String toString() {
        return String.format("%s: [%s]", this.getClass().getSimpleName(), this.getName());
    }

    @Override
    protected void ref() {
        gst.gst_object_ref(this);
    }

    @Override
    protected void unref() {
        gst.gst_object_unref(this);
    }

    void sink() {
        gst.gst_object_sink(this);
    }

    public GstObject getParent() {
        return gst.gst_object_get_parent(this);
    }

    public static <T extends GstObject> T objectFor(Pointer ptr, Class<T> defaultClass) {
        return GstObject.objectFor(ptr, defaultClass, true);
    }

    public static <T extends GstObject> T objectFor(Pointer ptr, Class<T> defaultClass, boolean needRef) {
        logger.entering("GstObject", "objectFor", new Object[]{ptr, defaultClass, needRef});
        return (T)((GstObject)GObject.objectFor(ptr, defaultClass, needRef));
    }

    protected synchronized void addListenerProxy(Class<? extends EventListener> listenerClass, EventListener listener, EventListenerProxy proxy) {
        Map<EventListener, EventListenerProxy> map = this.getListenerMap().get(listenerClass);
        if (map == null) {
            map = new HashMap<EventListener, EventListenerProxy>();
            this.getListenerMap().put(listenerClass, map);
        }
        map.put(listener, proxy);
    }

    protected synchronized EventListenerProxy removeListenerProxy(Class<? extends EventListener> listenerClass, EventListener listener) {
        Map<EventListener, EventListenerProxy> map = this.getListenerMap().get(listenerClass);
        if (map == null) {
            return null;
        }
        EventListenerProxy proxy = map.remove(listener);
        if (map.isEmpty()) {
            this.listenerMap.remove(listenerClass);
            if (this.listenerMap.isEmpty()) {
                this.listenerMap = null;
            }
        }
        return proxy;
    }

    private Map<Class<? extends EventListener>, Map<EventListener, EventListenerProxy>> getListenerMap() {
        if (this.listenerMap == null) {
            this.listenerMap = new HashMap<Class<? extends EventListener>, Map<EventListener, EventListenerProxy>>();
        }
        return this.listenerMap;
    }
}

