/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.io.monitor.FilesystemEntry;
import org.apache.commons.io.monitor.FilesystemListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesystemObserver
implements Serializable {
    private static final File[] EMPTY_FILES = new File[0];
    static final FilesystemEntry[] EMPTY_ENTRIES = new FilesystemEntry[0];
    private final List<FilesystemListener> listeners = new CopyOnWriteArrayList<FilesystemListener>();
    private final FilesystemEntry rootEntry;
    private final FileFilter fileFilter;
    private final Comparator<File> comparator;

    public FilesystemObserver(String directoryName) {
        this(new File(directoryName));
    }

    public FilesystemObserver(String directoryName, FileFilter fileFilter) {
        this(new File(directoryName), fileFilter);
    }

    public FilesystemObserver(String directoryName, FileFilter fileFilter, Comparator<File> comparator) {
        this(new File(directoryName), fileFilter, comparator);
    }

    public FilesystemObserver(File directory) {
        this(directory, (FileFilter)null);
    }

    public FilesystemObserver(File directory, FileFilter fileFilter) {
        this(directory, fileFilter, (Comparator<File>)null);
    }

    public FilesystemObserver(File directory, FileFilter fileFilter, Comparator<File> comparator) {
        this(new FilesystemEntry(directory), fileFilter, comparator);
    }

    protected FilesystemObserver(FilesystemEntry rootEntry, FileFilter fileFilter, Comparator<File> comparator) {
        if (rootEntry == null) {
            throw new IllegalArgumentException("Root entry is missing");
        }
        if (rootEntry.getFile() == null) {
            throw new IllegalArgumentException("Root directory is missing");
        }
        this.rootEntry = rootEntry;
        this.fileFilter = fileFilter;
        this.comparator = comparator == null ? NameFileComparator.NAME_COMPARATOR : comparator;
    }

    public FilesystemEntry getRootEntry() {
        return this.rootEntry;
    }

    public File getDirectory() {
        return this.rootEntry.getFile();
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public Comparator<File> getComparator() {
        return this.comparator;
    }

    public void addListener(FilesystemListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(FilesystemListener listener) {
        if (listener != null) {
            while (this.listeners.remove(listener)) {
            }
        }
    }

    public Iterable<FilesystemListener> getListeners() {
        return this.listeners;
    }

    public void initialize() throws Exception {
        this.rootEntry.refresh();
        File[] files = this.listFiles(this.rootEntry.getFile());
        FilesystemEntry[] children = files.length > 0 ? new FilesystemEntry[files.length] : EMPTY_ENTRIES;
        for (int i = 0; i < files.length; ++i) {
            children[i] = this.createFileEntry(this.rootEntry, files[i]);
        }
        this.rootEntry.setChildren(children);
    }

    public void destroy() throws Exception {
    }

    public void checkAndNotify() {
        for (FilesystemListener listener : this.listeners) {
            listener.onStart(this);
        }
        File rootFile = this.rootEntry.getFile();
        if (rootFile.exists()) {
            this.checkAndNotify(this.rootEntry, this.rootEntry.getChildren(), this.listFiles(rootFile));
        } else if (this.rootEntry.isExists()) {
            this.checkAndNotify(this.rootEntry, this.rootEntry.getChildren(), EMPTY_FILES);
        }
        for (FilesystemListener listener : this.listeners) {
            listener.onStop(this);
        }
    }

    private void checkAndNotify(FilesystemEntry parent, FilesystemEntry[] previous, File[] files) {
        int c = 0;
        FilesystemEntry[] current = files.length > 0 ? new FilesystemEntry[files.length] : EMPTY_ENTRIES;
        for (FilesystemEntry entry : previous) {
            while (c < files.length && this.comparator.compare(entry.getFile(), files[c]) > 0) {
                current[c] = this.createFileEntry(parent, files[c]);
                this.doCreate(current[c]);
                ++c;
            }
            if (c < files.length && this.comparator.compare(entry.getFile(), files[c]) == 0) {
                this.doMatch(entry, files[c]);
                this.checkAndNotify(entry, entry.getChildren(), this.listFiles(files[c]));
                current[c] = entry;
                ++c;
                continue;
            }
            this.checkAndNotify(entry, entry.getChildren(), EMPTY_FILES);
            this.doDelete(entry);
        }
        while (c < files.length) {
            current[c] = this.createFileEntry(parent, files[c]);
            this.doCreate(current[c]);
            ++c;
        }
        parent.setChildren(current);
    }

    private FilesystemEntry createFileEntry(FilesystemEntry parent, File file) {
        FilesystemEntry entry = parent.newChildInstance(file);
        entry.refresh();
        File[] files = this.listFiles(file);
        FilesystemEntry[] children = files.length > 0 ? new FilesystemEntry[files.length] : EMPTY_ENTRIES;
        for (int i = 0; i < files.length; ++i) {
            children[i] = this.createFileEntry(entry, files[i]);
        }
        entry.setChildren(children);
        return entry;
    }

    private void doCreate(FilesystemEntry entry) {
        FilesystemEntry[] children;
        for (FilesystemListener listener : this.listeners) {
            if (entry.isDirectory()) {
                listener.onDirectoryCreate(entry.getFile());
                continue;
            }
            listener.onFileCreate(entry.getFile());
        }
        for (FilesystemEntry aChildren : children = entry.getChildren()) {
            this.doCreate(aChildren);
        }
    }

    private void doMatch(FilesystemEntry entry, File file) {
        if (entry.hasChanged()) {
            for (FilesystemListener listener : this.listeners) {
                if (entry.isDirectory()) {
                    listener.onDirectoryChange(entry.getFile());
                    continue;
                }
                listener.onFileChange(entry.getFile());
            }
            entry.refresh();
        }
        entry.setFile(file);
    }

    private void doDelete(FilesystemEntry entry) {
        for (FilesystemListener listener : this.listeners) {
            if (entry.isDirectory()) {
                listener.onDirectoryDelete(entry.getFile());
                continue;
            }
            listener.onFileDelete(entry.getFile());
        }
    }

    private File[] listFiles(File file) {
        File[] children = null;
        if (file.isDirectory()) {
            File[] fileArray = children = this.fileFilter == null ? file.listFiles() : file.listFiles(this.fileFilter);
        }
        if (children == null) {
            children = EMPTY_FILES;
        }
        if (this.comparator != null && children.length > 1) {
            Arrays.sort(children, this.comparator);
        }
        return children;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("[file='");
        builder.append(this.getDirectory().getPath());
        if (this.fileFilter != null) {
            builder.append(", ");
            builder.append(this.fileFilter.toString());
        }
        builder.append(", listeners=");
        builder.append(this.listeners.size());
        builder.append("]");
        return builder.toString();
    }
}

