/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTableCellRendererCode;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.log.Logger;
import org.commonjukebox.plugins.model.PluginApi;

@PluginApi
public final class GuiUtils {
    private static Logger logger;
    private static Color borderColor;
    private static ComponentOrientation componentOrientation;
    private static Method setWindowShapeMethod;
    private static Method setWindowOpacityMethod;
    private static Method setWindowOpaqueMethod;
    private static Rectangle mainDeviceBounds;
    public static final int MAX_COMPONENTS_WIDTH = 1280;

    private GuiUtils() {
    }

    public static int getDeviceWidth() {
        return GuiUtils.mainDeviceBounds.width;
    }

    public static int getDeviceHeight() {
        return GuiUtils.mainDeviceBounds.height;
    }

    public static void setLocationInScreen(Window window, GraphicsDevice graphicsDevice) {
        Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
        window.setLocation(rectangle.width / 2 - window.getWidth() / 2 + rectangle.x, rectangle.height / 2 - window.getHeight() / 2 + rectangle.y);
    }

    public static void addCloseActionWithEscapeKey(final Window window, JRootPane jRootPane) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                window.setVisible(false);
            }
        };
        jRootPane.getInputMap(2).put(keyStroke, "ESCAPE");
        jRootPane.getActionMap().put("ESCAPE", abstractAction);
    }

    public static void addDisposeActionWithEscapeKey(final Window window, JRootPane jRootPane) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                window.dispose();
            }
        };
        jRootPane.getInputMap(2).put(keyStroke, "ESCAPE");
        jRootPane.getActionMap().put("ESCAPE", abstractAction);
    }

    public static void addAppIcons(Window window) {
        window.setIconImages(Arrays.asList(Images.getImage("logo16x16.png").getImage(), Images.getImage("logo32x32.png").getImage(), Images.getImage("logo90x90.png").getImage()));
    }

    public static void applyComponentOrientation(Container ... containerArray) {
        if (componentOrientation == null) {
            GuiUtils.setComponentOrientation();
        }
        for (Container container : containerArray) {
            container.applyComponentOrientation(componentOrientation);
        }
    }

    public static void collapseTree(JTree jTree) {
        for (int i = jTree.getRowCount() - 1; i > 0; --i) {
            jTree.collapseRow(i);
        }
        jTree.setSelectionRow(0);
    }

    public static void expandTree(JTree jTree) {
        for (int i = 1; i < jTree.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
        jTree.setSelectionRow(0);
    }

    public static Color getBackgroundColor() {
        return (Color)UIManager.get("Panel.background");
    }

    public static Color getForegroundColor() {
        return (Color)UIManager.get("Label.foreground");
    }

    public static Color getBorderColor() {
        return borderColor;
    }

    public static ComponentOrientation getComponentOrientation() {
        if (componentOrientation == null) {
            GuiUtils.setComponentOrientation();
        }
        return componentOrientation;
    }

    public static int getComponentOrientationAsSwingConstant() {
        if (componentOrientation == null) {
            GuiUtils.setComponentOrientation();
        }
        return componentOrientation.isLeftToRight() ? 2 : 4;
    }

    public static int getComponentWidthForResolution(int n, int n2) {
        int n3 = GuiUtils.mainDeviceBounds.width > 1280 ? 1280 : GuiUtils.mainDeviceBounds.width;
        return n2 * n3 / n;
    }

    public static int getComponentHeightForResolution(int n, int n2) {
        int n3 = GuiUtils.mainDeviceBounds.height;
        return n2 * n3 / n;
    }

    public static void setBorderColor(Color color) {
        borderColor = color;
    }

    private static void setComponentOrientation() {
        componentOrientation = Kernel.getInstance() == null ? ComponentOrientation.getOrientation(Locale.getDefault()) : ("ug".equalsIgnoreCase(ApplicationState.getInstance().getLocale().getLocale().getLanguage()) ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.getOrientation(ApplicationState.getInstance().getLocale().getLocale()));
    }

    public static void setWindowShape(Window window, Shape shape) {
        if (setWindowShapeMethod != null) {
            try {
                setWindowShapeMethod.invoke(null, window, shape);
            }
            catch (SecurityException securityException) {
                GuiUtils.getLogger().error("DESKTOP     ", securityException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                GuiUtils.getLogger().info("DESKTOP     ", "shaped windows not supported");
            }
            catch (IllegalAccessException illegalAccessException) {
                GuiUtils.getLogger().error("DESKTOP     ", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                GuiUtils.getLogger().error("DESKTOP     ", invocationTargetException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                GuiUtils.getLogger().error("DESKTOP     ", unsupportedOperationException);
            }
        }
    }

    public static void setWindowOpacity(Window window, float f) {
        if (setWindowOpacityMethod != null) {
            try {
                setWindowOpacityMethod.invoke(null, window, Float.valueOf(f));
            }
            catch (SecurityException securityException) {
                GuiUtils.getLogger().error("DESKTOP     ", securityException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                GuiUtils.getLogger().info("DESKTOP     ", "opaque windows not supported");
            }
            catch (IllegalAccessException illegalAccessException) {
                GuiUtils.getLogger().error("DESKTOP     ", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                GuiUtils.getLogger().info("DESKTOP     ", "opaque windows not supported");
                setWindowOpacityMethod = null;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                GuiUtils.getLogger().error("DESKTOP     ", unsupportedOperationException);
            }
        }
    }

    public static void setWindowOpaque(Window window, boolean bl) {
        if (setWindowOpaqueMethod != null) {
            try {
                setWindowOpaqueMethod.invoke(null, window, bl);
            }
            catch (SecurityException securityException) {
                GuiUtils.getLogger().error("DESKTOP     ", securityException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                GuiUtils.getLogger().info("DESKTOP     ", "opaque windows not supported");
            }
            catch (IllegalAccessException illegalAccessException) {
                GuiUtils.getLogger().error("DESKTOP     ", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                GuiUtils.getLogger().info("DESKTOP     ", "opaque windows not supported");
                setWindowOpaqueMethod = null;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                GuiUtils.getLogger().error("DESKTOP     ", unsupportedOperationException);
            }
        }
    }

    public static int getNumberOfScreenDevices() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length;
    }

    public static GraphicsDevice getGraphicsDeviceForLocation(int n, int n2) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (int i = 0; i < GuiUtils.getNumberOfScreenDevices(); ++i) {
            GraphicsDevice graphicsDevice = graphicsEnvironment.getScreenDevices()[i];
            if (!graphicsDevice.getDefaultConfiguration().getBounds().contains(n, n2)) continue;
            return graphicsDevice;
        }
        return graphicsEnvironment.getDefaultScreenDevice();
    }

    public static GraphicsDevice getGraphicsDeviceForLocation(Point point) {
        return GuiUtils.getGraphicsDeviceForLocation(point.x, point.y);
    }

    public static ComponentOrientationTableCellRendererCode getComponentOrientationTableCellRendererCode() {
        return new ComponentOrientationTableCellRendererCode();
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }

    static {
        borderColor = Color.BLACK;
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            setWindowShapeMethod = clazz.getDeclaredMethod("setWindowShape", Window.class, Shape.class);
            setWindowOpacityMethod = clazz.getDeclaredMethod("setWindowOpacity", Window.class, Float.TYPE);
            setWindowOpaqueMethod = clazz.getDeclaredMethod("setWindowOpaque", Window.class, Boolean.TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            GuiUtils.getLogger().info("DESKTOP     ", "class com.sun.awt.AWTUtilities not found");
        }
        catch (SecurityException securityException) {
            GuiUtils.getLogger().error("DESKTOP     ", securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            GuiUtils.getLogger().info("DESKTOP     ", "method in class com.sun.awt.AWTUtilities not found");
        }
        mainDeviceBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
    }

    public static class ComponentOrientationTableCellRendererCode
    extends AbstractTableCellRendererCode {
        @Override
        public Component getComponent(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (component instanceof JLabel) {
                GuiUtils.applyComponentOrientation((JLabel)component);
            }
            return component;
        }
    }
}

