/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.Lyrics;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines.AbstractLyricsEngine;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.StringUtils;

public class LyricsDirectoryEngine
extends AbstractLyricsEngine {
    private static final String WE_ARE_CURRENTLY_UNABLE_TO_SHOW_YOU_THE_LYRICS = "We are currently unable to show you the lyrics";
    private static final String BASE_URL = "http://www.lyricsdir.com/";
    private static final String CHARSET = "UTF-8";
    private Logger logger;

    public LyricsDirectoryEngine(Proxy proxy) {
        super(proxy);
    }

    @Override
    public Lyrics getLyricsFor(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(BASE_URL);
        stringBuilder.append(LyricsDirectoryEngine.encodeString(this.getString(string, string2)));
        stringBuilder.append("lyrics");
        stringBuilder.append(".html");
        try {
            String string3 = LyricsDirectoryEngine.readURL(this.getConnection(stringBuilder.toString()), CHARSET);
            String string4 = null;
            Source source = new Source((CharSequence)string3);
            List list = source.getAllElements("div");
            for (Element element : list) {
                if (!"protected_lyrics".equals(element.getAttributeValue("id"))) continue;
                string4 = element.getRenderer().toString();
            }
            return (string4 = this.reviewLyrics(string4)) != null && !string4.isEmpty() ? new Lyrics(string4, stringBuilder.toString()) : null;
        }
        catch (UnknownHostException unknownHostException) {
            this.getLogger().error("SERVICE     ", StringUtils.getString(unknownHostException.getClass().getCanonicalName(), " (", unknownHostException.getMessage(), ")"));
            return null;
        }
        catch (IOException iOException) {
            this.getLogger().error("SERVICE     ", StringUtils.getString(iOException.getClass().getCanonicalName(), " (", iOException.getMessage(), ")"));
            return null;
        }
    }

    private String reviewLyrics(String string) {
        if (string.contains(WE_ARE_CURRENTLY_UNABLE_TO_SHOW_YOU_THE_LYRICS)) {
            return null;
        }
        return string;
    }

    private String getString(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = string.toLowerCase().trim();
        string3 = string3.replaceAll("\\W", " ");
        String string4 = string2.toLowerCase().trim();
        string4 = string4.replaceAll("\\W", " ");
        for (String string5 : string3.split("\\s+")) {
            stringBuilder.append(string5);
            stringBuilder.append("-");
        }
        for (String string5 : string4.split(" ")) {
            stringBuilder.append(string5);
            stringBuilder.append("-");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getLyricsProviderName() {
        return "LyricsDirectory";
    }

    @Override
    public String getUrlForAddingNewLyrics(String string, String string2) {
        return "";
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

