/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.updates;

import java.io.IOException;
import java.net.Proxy;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.Constants;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.beans.ProxyBean;
import net.sourceforge.atunes.kernel.modules.updates.ApplicationVersion;
import net.sourceforge.atunes.kernel.modules.updates.VersionType;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.NetworkUtils;
import net.sourceforge.atunes.utils.StringUtils;
import net.sourceforge.atunes.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class UpdateHandler
extends AbstractHandler {
    private static final String updatesURL = "http://www.atunes.org/latest.xml";
    private static UpdateHandler instance = new UpdateHandler();

    private UpdateHandler() {
    }

    @Override
    public void applicationFinish() {
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
    }

    @Override
    protected void initHandler() {
    }

    public static UpdateHandler getInstance() {
        return instance;
    }

    @Override
    public void applicationStarted() {
        if (!Kernel.isNoUpdate()) {
            this.checkUpdates(ApplicationState.getInstance().getProxy(), false, false);
        }
    }

    public void checkUpdates(ProxyBean proxyBean, boolean bl, boolean bl2) {
        new CheckUpdatesSwingWorker(bl2, proxyBean, bl).execute();
    }

    ApplicationVersion getLastVersion(ProxyBean proxyBean) {
        ApplicationVersion applicationVersion = null;
        try {
            Proxy proxy = proxyBean != null ? new Proxy(proxyBean.getType().equals("HTTP_PROXY") ? Proxy.Type.HTTP : Proxy.Type.SOCKS, proxyBean.getUrl(), proxyBean.getPort(), proxyBean.getUser(), proxyBean.getPassword()) : null;
            URLConnection uRLConnection = NetworkUtils.getConnection(updatesURL, proxy);
            Document document = XMLUtils.getXMLDocument(NetworkUtils.readURL(uRLConnection));
            if (document == null) {
                throw new IOException(StringUtils.getString("Could not connect to ", updatesURL));
            }
            Element element = (Element)document.getElementsByTagName("latest").item(0);
            String string = XMLUtils.getChildElementContent(element, "date");
            int n = Integer.parseInt(XMLUtils.getChildElementContent(element, "majorNumber"));
            int n2 = Integer.parseInt(XMLUtils.getChildElementContent(element, "minorNumber"));
            int n3 = Integer.parseInt(XMLUtils.getChildElementContent(element, "revisionNumber"));
            String string2 = element.getAttribute("url");
            applicationVersion = new ApplicationVersion(string, n, n2, n3, VersionType.FINAL, "", string2);
        }
        catch (UnknownHostException unknownHostException) {
            UpdateHandler.getLogger().error("NETWORK     ", "Could not connect to www.atunes.org");
        }
        catch (IOException iOException) {
            UpdateHandler.getLogger().error("NETWORK     ", "Could not connect to www.atunes.org");
        }
        catch (Exception exception) {
            UpdateHandler.getLogger().internalError(exception);
        }
        return applicationVersion;
    }

    public static void main(String[] stringArray) {
        instance.checkUpdates(null, true, true);
    }

    private final class CheckUpdatesSwingWorker
    extends SwingWorker<ApplicationVersion, Void> {
        private final boolean showNoNewVersion;
        private final ProxyBean p;
        private final boolean alwaysInDialog;

        private CheckUpdatesSwingWorker(boolean bl, ProxyBean proxyBean, boolean bl2) {
            this.showNoNewVersion = bl;
            this.p = proxyBean;
            this.alwaysInDialog = bl2;
        }

        @Override
        protected ApplicationVersion doInBackground() throws Exception {
            return UpdateHandler.this.getLastVersion(this.p);
        }

        @Override
        protected void done() {
            try {
                ApplicationVersion applicationVersion = (ApplicationVersion)this.get();
                if (applicationVersion != null && applicationVersion.compareTo(Constants.VERSION) == 1) {
                    GuiHandler.getInstance().showNewVersionInfo(applicationVersion, this.alwaysInDialog);
                } else if (this.showNoNewVersion) {
                    GuiHandler.getInstance().showMessage(I18nUtils.getString("NOT_NEW_VERSION"));
                }
            }
            catch (InterruptedException interruptedException) {
                UpdateHandler.getLogger().internalError(interruptedException);
            }
            catch (ExecutionException executionException) {
                UpdateHandler.getLogger().internalError(executionException);
            }
        }
    }
}

