/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.updates;

import java.beans.ConstructorProperties;
import net.sourceforge.atunes.kernel.modules.updates.VersionType;
import net.sourceforge.atunes.utils.StringUtils;

public class ApplicationVersion
implements Comparable<ApplicationVersion> {
    private String date;
    private int majorNumber;
    private int minorNumber;
    private int revisionNumber;
    private VersionType versionType = VersionType.FINAL;
    private String name;
    private String downloadURL;

    ApplicationVersion() {
    }

    @ConstructorProperties(value={"date", "majorNumber", "minorNumber", "revisionNumber", "versionType", "name", "downloadURL"})
    public ApplicationVersion(String string, int n, int n2, int n3, VersionType versionType, String string2, String string3) {
        this.date = string;
        this.majorNumber = n;
        this.minorNumber = n2;
        this.revisionNumber = n3;
        this.versionType = versionType;
        this.name = string2;
        this.downloadURL = string3;
    }

    public boolean equals(Object object) {
        if (object instanceof ApplicationVersion) {
            return this.compareTo((ApplicationVersion)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return StringUtils.getString(new Object[]{this.majorNumber, ".", this.minorNumber, ".", this.revisionNumber, ".", this.versionType}).hashCode();
    }

    public String getDate() {
        return this.date;
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }

    public String getName() {
        return this.name;
    }

    public int getMajorNumber() {
        return this.majorNumber;
    }

    public int getMinorNumber() {
        return this.minorNumber;
    }

    public int getRevisionNumber() {
        return this.revisionNumber;
    }

    public String toString() {
        return StringUtils.getString(this.majorNumber, ".", this.minorNumber, ".", this.revisionNumber, " ", this.name, " ", this.versionType != VersionType.FINAL ? this.versionType : "");
    }

    public String toShortString() {
        return StringUtils.getString(this.majorNumber, ".", this.minorNumber, ".", this.revisionNumber, " ", this.versionType != VersionType.FINAL ? this.versionType : "");
    }

    public VersionType getVersionType() {
        return this.versionType;
    }

    @Override
    public int compareTo(ApplicationVersion applicationVersion) {
        if (applicationVersion == null) {
            throw new IllegalArgumentException();
        }
        if (this.majorNumber > applicationVersion.getMajorNumber()) {
            return 1;
        }
        if (this.majorNumber < applicationVersion.getMajorNumber()) {
            return -1;
        }
        if (this.minorNumber > applicationVersion.getMinorNumber()) {
            return 1;
        }
        if (this.minorNumber < applicationVersion.getMinorNumber()) {
            return -1;
        }
        if (this.revisionNumber > applicationVersion.getRevisionNumber()) {
            return 1;
        }
        if (this.revisionNumber < applicationVersion.getRevisionNumber()) {
            return -1;
        }
        return this.versionType.compareTo(applicationVersion.getVersionType());
    }
}

