/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.search.searchableobjects;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.search.RawSearchResult;
import net.sourceforge.atunes.kernel.modules.search.searchableobjects.AbstractCommonAudioFileSearchableObject;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;

public final class RepositorySearchableObject
extends AbstractCommonAudioFileSearchableObject {
    private static RepositorySearchableObject instance;
    private FSDirectory indexDirectory;

    private RepositorySearchableObject() {
    }

    public static RepositorySearchableObject getInstance() {
        if (instance == null) {
            instance = new RepositorySearchableObject();
        }
        return instance;
    }

    @Override
    public String getSearchableObjectName() {
        return I18nUtils.getString("REPOSITORY");
    }

    @Override
    public FSDirectory getIndexDirectory() throws IOException {
        if (this.indexDirectory == null) {
            this.indexDirectory = new SimpleFSDirectory(new File(StringUtils.getString(SystemProperties.getUserConfigFolder(Kernel.isDebug()), "/", "index/repository")));
        }
        return this.indexDirectory;
    }

    @Override
    public List<AudioObject> getSearchResult(List<RawSearchResult> list) {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        for (RawSearchResult rawSearchResult : list) {
            AudioFile audioFile = RepositoryHandler.getInstance().getFileIfLoaded(rawSearchResult.getDocument().get("url"));
            if (audioFile == null) continue;
            arrayList.add(audioFile);
        }
        return arrayList;
    }

    @Override
    public List<AudioObject> getElementsToIndex() {
        return new ArrayList<AudioObject>(RepositoryHandler.getInstance().getAudioFilesList());
    }
}

