/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.search.searchableobjects;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.search.SearchableObject;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public abstract class AbstractCommonAudioFileSearchableObject
implements SearchableObject {
    protected static final String INDEX_FIELD_TITLE = "title";
    protected static final String INDEX_FIELD_TRACK_NUMBER = "track";
    protected static final String INDEX_FIELD_ARTIST = "artist";
    protected static final String INDEX_FIELD_ALBUM_ARTIST = "album_artist";
    protected static final String INDEX_FIELD_ALBUM = "album";
    protected static final String INDEX_FIELD_COMPOSER = "composer";
    protected static final String INDEX_FIELD_YEAR = "year";
    protected static final String INDEX_FIELD_GENRE = "genre";
    protected static final String INDEX_FIELD_DURATION = "duration";
    protected static final String INDEX_FIELD_BITRATE = "bitrate";
    protected static final String INDEX_FIELD_FREQUENCY = "frequency";
    protected static final String INDEX_FIELD_SCORE = "score";
    protected static final String INDEX_FIELD_LYRICS = "lyrics";
    protected static final String INDEX_FIELD_FILENAME = "file_name";
    protected static final String INDEX_FIELD_URL = "url";

    @Override
    public List<String> getSearchableAttributes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(INDEX_FIELD_TITLE);
        arrayList.add(INDEX_FIELD_TRACK_NUMBER);
        arrayList.add(INDEX_FIELD_ARTIST);
        arrayList.add(INDEX_FIELD_ALBUM_ARTIST);
        arrayList.add(INDEX_FIELD_ALBUM);
        arrayList.add(INDEX_FIELD_COMPOSER);
        arrayList.add(INDEX_FIELD_YEAR);
        arrayList.add(INDEX_FIELD_GENRE);
        arrayList.add(INDEX_FIELD_DURATION);
        arrayList.add(INDEX_FIELD_BITRATE);
        arrayList.add(INDEX_FIELD_FREQUENCY);
        arrayList.add(INDEX_FIELD_SCORE);
        arrayList.add(INDEX_FIELD_FILENAME);
        arrayList.add(INDEX_FIELD_LYRICS);
        arrayList.add(INDEX_FIELD_URL);
        return arrayList;
    }

    @Override
    public Document getDocumentForElement(AudioObject audioObject) {
        if (audioObject instanceof AudioFile) {
            AudioFile audioFile = (AudioFile)audioObject;
            Document document = new Document();
            document.add((Fieldable)new Field(INDEX_FIELD_TITLE, audioFile.getTitle(), Field.Store.YES, Field.Index.ANALYZED));
            document.add((Fieldable)new Field(INDEX_FIELD_TRACK_NUMBER, String.valueOf(audioFile.getTrackNumber()), Field.Store.YES, Field.Index.NOT_ANALYZED));
            document.add((Fieldable)new Field(INDEX_FIELD_ARTIST, audioFile.getArtist(), Field.Store.YES, Field.Index.ANALYZED));
            document.add((Fieldable)new Field(INDEX_FIELD_ALBUM_ARTIST, audioFile.getAlbumArtist(), Field.Store.YES, Field.Index.ANALYZED));
            document.add((Fieldable)new Field(INDEX_FIELD_ALBUM, audioFile.getAlbum(), Field.Store.YES, Field.Index.ANALYZED));
            document.add((Fieldable)new Field(INDEX_FIELD_COMPOSER, audioFile.getComposer(), Field.Store.YES, Field.Index.ANALYZED));
            document.add((Fieldable)new Field(INDEX_FIELD_YEAR, audioFile.getYear(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            document.add((Fieldable)new Field(INDEX_FIELD_GENRE, audioFile.getGenre(), Field.Store.YES, Field.Index.ANALYZED));
            document.add((Fieldable)new Field(INDEX_FIELD_DURATION, String.valueOf(audioFile.getDuration()), Field.Store.YES, Field.Index.NOT_ANALYZED));
            document.add((Fieldable)new Field(INDEX_FIELD_BITRATE, String.valueOf(audioFile.getBitrate()), Field.Store.YES, Field.Index.NOT_ANALYZED));
            document.add((Fieldable)new Field(INDEX_FIELD_FREQUENCY, String.valueOf(audioFile.getFrequency()), Field.Store.YES, Field.Index.NOT_ANALYZED));
            document.add((Fieldable)new Field(INDEX_FIELD_SCORE, String.valueOf(audioFile.getStars()), Field.Store.YES, Field.Index.NOT_ANALYZED));
            document.add((Fieldable)new Field(INDEX_FIELD_LYRICS, audioFile.getLyrics(), Field.Store.YES, Field.Index.ANALYZED));
            document.add((Fieldable)new Field(INDEX_FIELD_FILENAME, audioFile.getNameWithoutExtension(), Field.Store.YES, Field.Index.ANALYZED));
            document.add((Fieldable)new Field(INDEX_FIELD_URL, audioFile.getUrl(), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field("any", StringUtils.getString(audioFile.getTitle(), " ", audioFile.getTrackNumber(), " ", audioFile.getArtist(), " ", audioFile.getAlbumArtist(), " ", audioFile.getAlbum(), " ", audioFile.getComposer(), " ", audioFile.getYear(), " ", audioFile.getGenre()), Field.Store.YES, Field.Index.ANALYZED));
            return document;
        }
        return null;
    }
}

