/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.search;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.modules.search.RawSearchResult;
import net.sourceforge.atunes.kernel.modules.search.SearchIndexNotAvailableException;
import net.sourceforge.atunes.kernel.modules.search.SearchQuerySyntaxException;
import net.sourceforge.atunes.kernel.modules.search.SearchableObject;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;

public final class SearchHandler
extends AbstractHandler {
    public static final String DEFAULT_INDEX = "any";
    private static final String INDEX_FIELD_DUMMY = "dummy";
    private static SearchHandler instance = new SearchHandler();
    private List<SearchableObject> searchableObjects;
    private List<String> searchOperators;
    private volatile Map<SearchableObject, Boolean> currentIndexingWorks;
    private Map<SearchableObject, ReadWriteLock> indexLocks;

    private SearchHandler() {
    }

    @Override
    public void applicationFinish() {
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
    }

    @Override
    public void applicationStarted() {
    }

    @Override
    protected void initHandler() {
        this.currentIndexingWorks = new HashMap<SearchableObject, Boolean>();
        this.searchableObjects = new ArrayList<SearchableObject>();
        this.indexLocks = new HashMap<SearchableObject, ReadWriteLock>();
        this.searchOperators = new ArrayList<String>();
        this.searchOperators.add(":");
    }

    public void registerSearchableObject(SearchableObject searchableObject) {
        this.currentIndexingWorks.put(searchableObject, Boolean.FALSE);
        this.indexLocks.put(searchableObject, new ReentrantReadWriteLock(true));
        this.searchableObjects.add(searchableObject);
    }

    public void unregisterSearchableObject(SearchableObject searchableObject) {
        this.currentIndexingWorks.remove(searchableObject);
        this.indexLocks.remove(searchableObject);
        this.searchableObjects.remove(searchableObject);
    }

    public static SearchHandler getInstance() {
        return instance;
    }

    public void startSearch() {
        for (SearchableObject searchableObject : this.searchableObjects) {
            this.updateSearchIndex(searchableObject);
        }
        ControllerProxy.getInstance().getCustomSearchController().setListOfSearchableObjects(this.searchableObjects);
        ControllerProxy.getInstance().getCustomSearchController().setListOfOperators(this.searchOperators);
        ControllerProxy.getInstance().getCustomSearchController().showSearchDialog();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AudioObject> search(SearchableObject searchableObject, String string) throws SearchIndexNotAvailableException, SearchQuerySyntaxException {
        Object object;
        ReadWriteLock readWriteLock = this.indexLocks.get(searchableObject);
        IndexSearcher indexSearcher = null;
        try {
            readWriteLock.readLock().lock();
            String string2 = this.applyQueryTransformations(string);
            Query query = new QueryParser(Version.LUCENE_CURRENT, DEFAULT_INDEX, (Analyzer)new SimpleAnalyzer()).parse(string2);
            indexSearcher = new IndexSearcher((Directory)searchableObject.getIndexDirectory(), true);
            TopDocs topDocs = indexSearcher.search(query, 1000);
            ArrayList<RawSearchResult> arrayList = new ArrayList<RawSearchResult>();
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                arrayList.add(new RawSearchResult(indexSearcher.doc(scoreDoc.doc), scoreDoc.score));
            }
            List<AudioObject> list = searchableObject.getSearchResult(arrayList);
            SearchHandler.getLogger().debug("REPOSITORY  ", "Query: ", string2, " (", list.size(), " search results)");
            object = list;
        }
        catch (IOException iOException) {
            try {
                throw new SearchIndexNotAvailableException();
                catch (ParseException parseException) {
                    throw new SearchQuerySyntaxException();
                }
            }
            catch (Throwable throwable) {
                ClosingUtils.close(indexSearcher);
                readWriteLock.readLock().unlock();
                throw throwable;
            }
        }
        ClosingUtils.close((Closeable)indexSearcher);
        readWriteLock.readLock().unlock();
        return object;
    }

    private String applyQueryTransformations(String string) {
        String string2 = string.replaceAll(LogicalOperator.NOT.toString(), StringUtils.getString(INDEX_FIELD_DUMMY, ":", INDEX_FIELD_DUMMY, " NOT"));
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.matches("\"[0-9]+\"")) {
                stringBuilder.append(StringUtils.getString("[", string3, " TO ", string3, "]"));
            } else {
                stringBuilder.append(string3);
            }
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private void updateSearchIndex(SearchableObject searchableObject) {
        RefreshSearchIndexSwingWorker refreshSearchIndexSwingWorker = new RefreshSearchIndexSwingWorker(searchableObject);
        if (this.currentIndexingWorks.get(searchableObject) == null || !this.currentIndexingWorks.get(searchableObject).booleanValue()) {
            this.currentIndexingWorks.put(searchableObject, Boolean.TRUE);
            refreshSearchIndexSwingWorker.execute();
        }
    }

    public static enum LogicalOperator {
        AND,
        OR,
        NOT;

    }

    private final class RefreshSearchIndexSwingWorker
    extends SwingWorker<Void, Void> {
        private final SearchableObject searchableObject;
        private IndexWriter indexWriter;

        private RefreshSearchIndexSwingWorker(SearchableObject searchableObject) {
            this.searchableObject = searchableObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doInBackground() {
            ReadWriteLock readWriteLock = (ReadWriteLock)SearchHandler.this.indexLocks.get(this.searchableObject);
            try {
                readWriteLock.writeLock().lock();
                this.initSearchIndex();
                this.updateSearchIndex(this.searchableObject.getElementsToIndex());
                this.finishSearchIndex();
                Void void_ = null;
                return void_;
            }
            finally {
                readWriteLock.writeLock().unlock();
                ClosingUtils.close((Closeable)this.indexWriter);
                SearchHandler.this.currentIndexingWorks.put(this.searchableObject, Boolean.FALSE);
            }
        }

        @Override
        protected void done() {
        }

        private void initSearchIndex() {
            SearchHandler.getLogger().info("HANDLER     ", "Updating index for " + this.searchableObject.getClass());
            try {
                FileUtils.deleteDirectory((File)this.searchableObject.getIndexDirectory().getFile());
                this.indexWriter = new IndexWriter((Directory)this.searchableObject.getIndexDirectory(), (Analyzer)new SimpleAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
            }
            catch (CorruptIndexException corruptIndexException) {
                SearchHandler.getLogger().error("HANDLER     ", (Object)corruptIndexException);
            }
            catch (LockObtainFailedException lockObtainFailedException) {
                SearchHandler.getLogger().error("HANDLER     ", (Object)lockObtainFailedException);
            }
            catch (IOException iOException) {
                SearchHandler.getLogger().error("HANDLER     ", iOException);
            }
        }

        private void updateSearchIndex(List<AudioObject> list) {
            SearchHandler.getLogger().info("HANDLER     ", "update search index");
            if (this.indexWriter != null) {
                for (AudioObject audioObject : list) {
                    Document document = this.searchableObject.getDocumentForElement(audioObject);
                    document.add((Fieldable)new Field(SearchHandler.INDEX_FIELD_DUMMY, SearchHandler.INDEX_FIELD_DUMMY, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
                    try {
                        this.indexWriter.addDocument(document);
                    }
                    catch (CorruptIndexException corruptIndexException) {
                        SearchHandler.getLogger().error("HANDLER     ", (Object)corruptIndexException);
                    }
                    catch (IOException iOException) {
                        SearchHandler.getLogger().error("HANDLER     ", iOException);
                    }
                }
            }
        }

        private void finishSearchIndex() {
            SearchHandler.getLogger().info("HANDLER     ", StringUtils.getString("Update index for ", this.searchableObject.getClass(), " finished"));
            if (this.indexWriter != null) {
                try {
                    this.indexWriter.optimize();
                    this.indexWriter.close();
                    this.indexWriter = null;
                }
                catch (CorruptIndexException corruptIndexException) {
                    SearchHandler.getLogger().error("HANDLER     ", (Object)corruptIndexException);
                }
                catch (IOException iOException) {
                    SearchHandler.getLogger().error("HANDLER     ", iOException);
                }
            }
        }
    }
}

