/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.tags.writer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.kernel.modules.pattern.AbstractPattern;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.EditTagInfo;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.AbstractChangeTagProcess;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.TagModifier;

public class EditTagFromFileNamePatternProcess
extends AbstractChangeTagProcess {
    private String pattern;
    private Map<AudioFile, EditTagInfo> filesAndTags;

    public EditTagFromFileNamePatternProcess(List<AudioFile> list, String string) {
        super(list);
        this.pattern = string;
    }

    @Override
    protected void retrieveInformationBeforeChangeTags() {
        super.retrieveInformationBeforeChangeTags();
        if (this.filesAndTags == null) {
            this.filesAndTags = new HashMap<AudioFile, EditTagInfo>();
            for (AudioFile audioFile : this.getFilesToChange()) {
                Map<String, String> map = AbstractPattern.getPatternMatches(this.pattern, audioFile.getNameWithoutExtension(), false);
                EditTagInfo editTagInfo = AbstractPattern.getEditTagInfoFromMatches(map);
                this.filesAndTags.put(audioFile, editTagInfo);
            }
        }
    }

    @Override
    protected void changeTag(AudioFile audioFile) {
        TagModifier.setInfo(audioFile, AudioFile.getNewTag(audioFile, this.filesAndTags.get(audioFile)));
    }
}

