/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.device.DeviceHandler;
import net.sourceforge.atunes.kernel.modules.repository.LoaderListener;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryFiller;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.data.Folder;
import net.sourceforge.atunes.kernel.modules.repository.data.Genre;
import net.sourceforge.atunes.kernel.modules.repository.data.Repository;
import net.sourceforge.atunes.kernel.modules.repository.data.Year;
import net.sourceforge.atunes.kernel.modules.repository.statistics.StatisticsHandler;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.AbstractTag;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.Timer;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.AudioFilePictureUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class RepositoryLoader
extends Thread {
    private Logger logger;
    private LoaderListener listener;
    private List<File> folders;
    private boolean refresh;
    private boolean interrupt;
    private Repository oldRepository;
    private Repository repository;
    private int totalFilesToLoad;
    private int filesLoaded;
    private long startReadTime;
    private String fastRepositoryPath;
    private int fastFirstChar;

    public RepositoryLoader(List<File> list, Repository repository, Repository repository2, boolean bl) {
        this.refresh = bl;
        this.folders = list;
        this.oldRepository = repository;
        this.repository = repository2;
        this.setPriority(10);
    }

    static void addToRepository(Repository repository, List<File> list) {
        repository.setDirty(true);
        HashSet<File> hashSet = new HashSet<File>();
        for (File file : list) {
            hashSet.add(file.getParentFile());
        }
        for (File file : hashSet) {
            String string = RepositoryLoader.getRepositoryFolderContaining(repository, file).getAbsolutePath().replace('\\', '/');
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 2);
            }
            int n = string.length() + 1;
            File[] fileArray = file.listFiles();
            ArrayList<File> arrayList = new ArrayList<File>();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    if (!file2.getName().toUpperCase().endsWith("JPG")) continue;
                    arrayList.add(file2);
                }
            }
            Map<String, AudioFile> map = repository.getAudioFiles();
            for (File file2 : list) {
                if (!file2.getParentFile().equals(file)) continue;
                Object var12_16 = null;
                AudioFile audioFile = new AudioFile(file2);
                audioFile.setExternalPictures(arrayList);
                map.put(audioFile.getUrl(), audioFile);
                String string2 = audioFile.getUrl().replace('\\', '/');
                int n2 = string2.lastIndexOf(47) + 1;
                String string3 = n < n2 ? string2.substring(n, n2) : ".";
                RepositoryFiller.addToArtistStructure(repository, audioFile);
                RepositoryFiller.addToFolderStructure(repository, RepositoryLoader.getRepositoryFolderContaining(repository, file), string3, audioFile);
                RepositoryFiller.addToGenreStructure(repository, audioFile);
                RepositoryFiller.addToYearStructure(repository, audioFile);
                repository.setTotalSizeInBytes(repository.getTotalSizeInBytes() + audioFile.getFile().length());
                repository.addDurationInSeconds(audioFile.getDuration());
            }
        }
    }

    private static int countFiles(File file) {
        int n = 0;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return n;
        }
        for (File file2 : fileArray) {
            if (AudioFile.isValidAudioFile(file2)) {
                ++n;
                continue;
            }
            if (!file2.isDirectory()) continue;
            n += RepositoryLoader.countFiles(file2);
        }
        return n;
    }

    static int countFilesInRepository(Repository repository) {
        int n = 0;
        for (File file : repository.getFolders()) {
            n += RepositoryLoader.countFiles(file);
        }
        return n;
    }

    private static File getRepositoryFolderContaining(Repository repository, File file) {
        String string = file.getAbsolutePath();
        for (File file2 : repository.getFolders()) {
            if (!string.startsWith(file2.getAbsolutePath())) continue;
            return file2;
        }
        return null;
    }

    public static List<AudioFile> getSongsForFolder(File file, LoaderListener loaderListener) {
        ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
        File[] fileArray = file.listFiles();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        ArrayList<File> arrayList3 = new ArrayList<File>();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (AudioFile.isValidAudioFile(file2)) {
                    arrayList3.add(file2);
                    continue;
                }
                if (file2.isDirectory()) {
                    arrayList.addAll(RepositoryLoader.getSongsForFolder(file2, loaderListener));
                    continue;
                }
                if (!file2.getName().toUpperCase().endsWith("JPG")) continue;
                arrayList2.add(file2);
            }
            for (int i = 0; i < arrayList3.size(); ++i) {
                AudioFile audioFile = null;
                audioFile = new AudioFile((File)arrayList3.get(i));
                audioFile.setExternalPictures(arrayList2);
                arrayList.add(audioFile);
                if (loaderListener == null) continue;
                loaderListener.notifyFileLoaded();
            }
        }
        return arrayList;
    }

    public static List<AudioFile> getSongsForFolders(List<File> list, LoaderListener loaderListener) {
        int n = 0;
        for (File object : list) {
            n += RepositoryLoader.countFiles(object);
        }
        if (loaderListener != null) {
            loaderListener.notifyFilesInRepository(n);
        }
        ArrayList arrayList = new ArrayList();
        for (File file : list) {
            arrayList.addAll(RepositoryLoader.getSongsForFolder(file, loaderListener));
        }
        if (loaderListener != null) {
            loaderListener.notifyFinishRead(null);
        }
        return arrayList;
    }

    static void refreshFile(Repository repository, AudioFile audioFile) {
        repository.setDirty(true);
        try {
            Year year;
            Serializable serializable;
            AbstractTag abstractTag = audioFile.getTag();
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            if (abstractTag != null) {
                string = abstractTag.getAlbumArtist();
                string2 = abstractTag.getArtist();
                string3 = abstractTag.getAlbum();
                string4 = abstractTag.getGenre();
                String string6 = string5 = abstractTag.getYear() > 0 ? Integer.toString(abstractTag.getYear()) : "";
            }
            if (string2 == null || string2.equals("")) {
                string2 = Artist.getUnknownArtist();
            }
            if (string3 == null || string3.equals("")) {
                string3 = Album.getUnknownAlbum();
            }
            if (string4 == null || string4.equals("")) {
                string4 = Genre.getUnknownGenre();
            }
            if (string5 == null || string5.equals("")) {
                string5 = Year.getUnknownYear();
            }
            boolean bl = true;
            Artist artist = repository.getArtistStructure().get(string);
            if (artist == null) {
                artist = repository.getArtistStructure().get(string2);
                bl = false;
            }
            if (artist != null) {
                serializable = artist.getAlbum(string3);
                if (serializable != null) {
                    if (((Album)serializable).getAudioObjects().size() == 1) {
                        artist.removeAlbum((Album)serializable);
                    } else {
                        ((Album)serializable).removeAudioFile(audioFile);
                    }
                    if (artist.getAudioObjects().size() <= 0) {
                        repository.getArtistStructure().remove(artist.getName());
                    }
                }
                if (bl && (artist = repository.getArtistStructure().get(string2)) != null && (serializable = artist.getAlbum(string3)) != null) {
                    if (((Album)serializable).getAudioObjects().size() == 1) {
                        artist.removeAlbum((Album)serializable);
                    } else {
                        ((Album)serializable).removeAudioFile(audioFile);
                    }
                    if (artist.getAudioObjects().size() <= 1) {
                        repository.getArtistStructure().remove(artist.getName());
                    }
                }
            }
            if ((serializable = repository.getGenreStructure().get(string4)) != null) {
                ((Genre)serializable).removeAudioFile(audioFile);
                if (((Genre)serializable).getAudioObjects().size() <= 1) {
                    repository.getGenreStructure().remove(string4);
                }
            }
            if ((year = repository.getYearStructure().get(string5)) != null) {
                year.removeAudioFile(audioFile);
                if (year.getAudioObjects().size() <= 1) {
                    repository.getYearStructure().remove(string5);
                }
            }
            audioFile.refreshTag();
            RepositoryFiller.addToArtistStructure(repository, audioFile);
            RepositoryFiller.addToGenreStructure(repository, audioFile);
            RepositoryFiller.addToYearStructure(repository, audioFile);
            AbstractTag abstractTag2 = audioFile.getTag();
            if (abstractTag2 != null) {
                Album album;
                Artist artist2;
                boolean bl2 = !abstractTag.getArtist().equals(abstractTag2.getArtist());
                boolean bl3 = !abstractTag.getAlbum().equals(abstractTag2.getAlbum());
                boolean bl4 = false;
                if (bl2 && (artist2 = repository.getArtistStructure().get(abstractTag.getArtist())) == null) {
                    StatisticsHandler.getInstance().updateArtist(abstractTag.getArtist(), abstractTag2.getArtist());
                    bl4 = true;
                }
                if (bl3 && (album = (artist2 = bl4 ? repository.getArtistStructure().get(abstractTag2.getArtist()) : repository.getArtistStructure().get(abstractTag.getArtist())).getAlbum(abstractTag.getAlbum())) == null) {
                    StatisticsHandler.getInstance().updateAlbum(artist2.getName(), abstractTag.getAlbum(), abstractTag2.getAlbum());
                }
            }
        }
        catch (Exception exception) {
            new Logger().error("FILE READ   ", exception.getMessage());
        }
    }

    public void addRepositoryLoaderListener(LoaderListener loaderListener) {
        this.listener = loaderListener;
    }

    private int countFilesInDir(File file) {
        int n = 0;
        if (!this.interrupt) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return n;
            }
            for (File file2 : fileArray) {
                if (AudioFile.isValidAudioFile(file2)) {
                    ++n;
                    continue;
                }
                if (!file2.isDirectory()) continue;
                n += this.countFilesInDir(file2);
            }
        }
        return n;
    }

    private int countFilesInDir(List<File> list) {
        int n = 0;
        for (File file : list) {
            n += this.countFilesInDir(file);
        }
        return n;
    }

    void interruptLoad() {
        this.getLogger().info("REPOSITORY  ", "Load interrupted");
        this.interrupt = true;
    }

    private void loadRepository() {
        if (!this.refresh) {
            this.totalFilesToLoad = this.countFilesInDir(this.folders);
            if (this.listener != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RepositoryLoader.this.listener.notifyFilesInRepository(RepositoryLoader.this.totalFilesToLoad);
                    }
                });
            }
        }
        this.startReadTime = System.currentTimeMillis();
        for (File file : this.folders) {
            this.fastRepositoryPath = file.getAbsolutePath().replace('\\', '/');
            if (this.fastRepositoryPath.endsWith("/")) {
                this.fastRepositoryPath = this.fastRepositoryPath.substring(0, this.fastRepositoryPath.length() - 2);
            }
            this.fastFirstChar = this.fastRepositoryPath.length() + 1;
            this.navigateDir(file, file);
        }
    }

    private void navigateDir(File file, File file2) {
        if (!this.interrupt) {
            this.processDirectories(file2, file);
            List<File> list = this.processPictures(file2);
            this.processAudioFiles(file2, list, file);
        }
    }

    private List<File> processPictures(File file) {
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return AudioFilePictureUtils.isValidPicture(file);
            }
        });
        return fileArray.length > 0 ? Arrays.asList(fileArray) : null;
    }

    private void processDirectories(File file, File file2) {
        File[] fileArray;
        for (File file3 : fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            this.navigateDir(file2, file3);
        }
    }

    private void processAudioFiles(File file, List<File> list, File file2) {
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return AudioFile.isValidAudioFile(file);
            }
        });
        String string = file.getAbsolutePath().replace('\\', '/');
        int n = string.lastIndexOf(47) + 1;
        String string2 = this.fastFirstChar <= n ? string.substring(this.fastFirstChar) : ".";
        if (this.listener != null && !this.refresh) {
            this.listener.notifyCurrentPath(string2);
        }
        for (File file3 : fileArray) {
            AudioFile audioFile;
            AudioFile audioFile2 = null;
            audioFile2 = this.oldRepository == null ? new AudioFile(file3) : ((audioFile = this.oldRepository.getFile(file3.getAbsolutePath())) != null && audioFile.isUpToDate() ? audioFile : new AudioFile(file3));
            audioFile2.setExternalPictures(list);
            if (!this.refresh && this.listener != null) {
                this.listener.notifyFileLoaded();
            }
            ++this.filesLoaded;
            RepositoryFiller.addToRepository(this.repository, audioFile2);
            RepositoryFiller.addToArtistStructure(this.repository, audioFile2);
            RepositoryFiller.addToFolderStructure(this.repository, file2, string2, audioFile2);
            RepositoryFiller.addToGenreStructure(this.repository, audioFile2);
            RepositoryFiller.addToYearStructure(this.repository, audioFile2);
            if (this.refresh || this.listener == null || this.filesLoaded % 50 != 0) continue;
            long l = System.currentTimeMillis();
            long l2 = this.filesLoaded != 0 ? (long)(this.totalFilesToLoad - this.filesLoaded) * (l - this.startReadTime) / (long)this.filesLoaded : 0L;
            this.listener.notifyRemainingTime(l2);
            this.listener.notifyReadProgress();
        }
    }

    private void notifyFinish() {
        this.repository.setDirty(true);
        AudioFile.getImageCache().clearCache();
        if (this.listener == null) {
            return;
        }
        if (this.refresh) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RepositoryLoader.this.listener.notifyFinishRefresh(RepositoryLoader.this);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RepositoryLoader.this.listener.notifyFinishRead(RepositoryLoader.this);
                }
            });
        }
    }

    @Override
    public void run() {
        this.getLogger().info("REPOSITORY  ", "Starting repository read");
        Timer timer = new Timer();
        timer.start();
        if (!this.folders.isEmpty()) {
            this.loadRepository();
        } else {
            this.getLogger().error("REPOSITORY  ", "No folders selected for repository");
        }
        if (!this.interrupt) {
            double d = timer.stop();
            long l = this.repository.countFiles();
            double d2 = d / (double)l;
            this.getLogger().info("REPOSITORY  ", StringUtils.getString("Read repository process DONE (", l, " files, ", d, " seconds, ", StringUtils.toString(d2, 4), " seconds / file)"));
            this.notifyFinish();
        }
    }

    Repository getOldRepository() {
        return this.oldRepository;
    }

    static void addExternalPictureForAlbum(Repository repository, String string, String string2, File file) {
        if (repository != null) {
            Artist artist = repository.getArtistStructure().get(string);
            if (artist == null) {
                return;
            }
            Album album = artist.getAlbum(string2);
            if (album == null) {
                return;
            }
            repository.setDirty(true);
            List<AudioFile> list = album.getAudioFiles();
            for (AudioFile audioFile : list) {
                audioFile.addExternalPicture(file);
            }
        }
    }

    static void deleteFile(AudioFile audioFile) {
        String string = audioFile.getAlbumArtist();
        String string2 = audioFile.getArtist();
        String string3 = audioFile.getAlbum();
        String string4 = audioFile.getGenre();
        String string5 = audioFile.getYear();
        if (RepositoryLoader.getFolderForFile(audioFile) != null) {
            Year year;
            Serializable serializable;
            Artist artist;
            RepositoryHandler.getInstance().getRepository().setDirty(true);
            Folder folder = RepositoryLoader.getFolderForFile(audioFile);
            if (folder != null) {
                folder.removeAudioFile(audioFile);
                if (folder.isEmpty()) {
                    folder.getParentFolder().removeFolder(folder);
                }
            }
            if ((artist = RepositoryHandler.getInstance().getArtistStructure().get(string)) == null) {
                artist = RepositoryHandler.getInstance().getArtistStructure().get(string2);
            }
            if (artist != null && (serializable = artist.getAlbum(string3)) != null) {
                if (((Album)serializable).getAudioObjects().size() == 1) {
                    artist.removeAlbum((Album)serializable);
                } else {
                    ((Album)serializable).removeAudioFile(audioFile);
                }
                if (artist.getAudioObjects().size() <= 1) {
                    RepositoryHandler.getInstance().getArtistStructure().remove(artist.getName());
                }
            }
            if ((serializable = RepositoryHandler.getInstance().getGenreStructure().get(string4)) != null) {
                ((Genre)serializable).removeAudioFile(audioFile);
                if (((Genre)serializable).getAudioObjects().size() <= 1) {
                    RepositoryHandler.getInstance().getGenreStructure().remove(string4);
                }
            }
            if ((year = RepositoryHandler.getInstance().getYearStructure().get(string5)) != null) {
                year.removeAudioFile(audioFile);
                if (year.getAudioObjects().size() <= 1) {
                    RepositoryHandler.getInstance().getYearStructure().remove(string5);
                }
            }
            RepositoryHandler.getInstance().getRepository().getAudioFiles().remove(audioFile.getUrl());
            RepositoryHandler.getInstance().getRepository().setTotalSizeInBytes(RepositoryHandler.getInstance().getRepository().getTotalSizeInBytes() - audioFile.getFile().length());
            RepositoryHandler.getInstance().getRepository().removeDurationInSeconds(audioFile.getDuration());
        } else if (DeviceHandler.getInstance().isDevicePath(audioFile.getUrl())) {
            RepositoryHandler.getRepositoryHandlerLogger().info("REPOSITORY  ", StringUtils.getString("Deleted file ", audioFile, " from device"));
        }
    }

    private static Folder getFolderForFile(AudioFile audioFile) {
        File file = RepositoryHandler.getInstance().getRepositoryFolderContainingFile(audioFile);
        if (file == null) {
            return null;
        }
        Folder folder = RepositoryHandler.getInstance().getRepository().getFolderStructure().get(file.getAbsolutePath());
        String string = audioFile.getFile().getParentFile().getAbsolutePath();
        string = string.replace(file.getAbsolutePath(), "");
        Folder folder2 = folder;
        StringTokenizer stringTokenizer = new StringTokenizer(string, SystemProperties.FILE_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            folder2 = folder2.getFolder(string2);
        }
        return folder2;
    }

    static void renameFile(AudioFile audioFile, File file, File file2) {
        RepositoryHandler.getInstance().getRepository().setDirty(true);
        audioFile.setFile(file2);
        RepositoryHandler.getInstance().getRepository().getAudioFiles().remove(file.getAbsolutePath());
        RepositoryHandler.getInstance().getRepository().getAudioFiles().put(file2.getAbsolutePath(), audioFile);
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

