/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository;

import java.io.Serializable;
import javax.swing.ImageIcon;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.LyricsCache;
import net.sourceforge.atunes.misc.AbstractCache;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.ImageSize;

public class ImageCache
extends AbstractCache {
    private static final String COVERS = "covers";
    private Logger logger;

    public ImageCache() {
        super(LyricsCache.class.getResource("/settings/ehcache-covers.xml"));
    }

    public synchronized boolean clearCache() {
        try {
            this.getCache().removeAll();
            this.getCache().flush();
        }
        catch (IllegalStateException illegalStateException) {
            this.getLogger().info("FILE DELETE ", "Could not delete all files from cover cache");
            return true;
        }
        catch (CacheException cacheException) {
            this.getLogger().info("FILE DELETE ", "Could not delete all files from cover cache");
            return true;
        }
        return false;
    }

    public synchronized boolean clear(AudioFile audioFile) {
        try {
            for (ImageSize imageSize : ImageSize.values()) {
                this.getCache().remove((Serializable)Integer.valueOf(ImageCache.id(audioFile, imageSize)));
            }
            this.getCache().flush();
        }
        catch (IllegalStateException illegalStateException) {
            this.getLogger().info("FILE DELETE ", "Could not delete all files from cover cache");
            return true;
        }
        catch (CacheException cacheException) {
            this.getLogger().info("FILE DELETE ", "Could not delete all files from cover cache");
            return true;
        }
        return false;
    }

    public synchronized ImageIcon retrieveImage(AudioFile audioFile, ImageSize imageSize) {
        Element element = this.getCache().get((Serializable)Integer.valueOf(ImageCache.id(audioFile, imageSize)));
        if (element != null) {
            return (ImageIcon)element.getValue();
        }
        return null;
    }

    private static int id(AudioFile audioFile, ImageSize imageSize) {
        return (audioFile.getUrl() + imageSize.toString()).hashCode();
    }

    public synchronized void storeImage(AudioFile audioFile, ImageSize imageSize, ImageIcon imageIcon) {
        if (audioFile == null || imageSize == null || imageIcon == null) {
            return;
        }
        Element element = new Element((Serializable)Integer.valueOf(ImageCache.id(audioFile, imageSize)), (Serializable)imageIcon);
        this.getCache().put(element);
        this.getLogger().debug("CACHE       ", "Stored image for ", audioFile);
    }

    private Cache getCache() {
        return this.getCache(COVERS);
    }

    public void shutdown() {
        this.getCache().dispose();
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

