/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.player.mplayer;

import java.io.PrintStream;
import net.sourceforge.atunes.utils.StringUtils;

class MPlayerCommandWriter {
    private volatile Process process;
    private volatile PrintStream streamToProcess;

    MPlayerCommandWriter(Process process) {
        this.process = process;
    }

    private void sendCommand(String string) {
        if (this.process != null) {
            if (this.streamToProcess == null) {
                this.streamToProcess = new PrintStream(this.process.getOutputStream());
            }
            this.streamToProcess.print(string);
            this.streamToProcess.print('\n');
            this.streamToProcess.flush();
        }
    }

    void sendGetDurationCommand() {
        this.sendCommand("get_time_length");
    }

    void sendGetPositionCommand() {
        this.sendCommand("get_time_pos");
    }

    void sendMuteCommand() {
        this.sendCommand("mute");
    }

    void sendPauseCommand() {
        this.sendCommand("pause");
    }

    void sendResumeCommand() {
        this.sendCommand("pause");
    }

    void sendSeekCommand(long l) {
        this.sendCommand(StringUtils.getString("seek ", l / 1000L, " 2"));
        this.sendPauseCommand();
    }

    void sendStopCommand() {
        this.sendCommand("quit");
    }

    void sendVolumeCommand(int n) {
        this.sendCommand(StringUtils.getString("pausing_keep volume ", n, " 1"));
    }

    Process getProcess() {
        return this.process;
    }

    void finishProcess() {
        this.process = null;
        this.streamToProcess.close();
        this.streamToProcess = null;
    }
}

