/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.player.mplayer;

import net.sourceforge.atunes.kernel.modules.player.mplayer.AbstractMPlayerOutputReader;
import net.sourceforge.atunes.kernel.modules.player.mplayer.MPlayerEngine;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.data.Format;

class AudioFileMPlayerOutputReader
extends AbstractMPlayerOutputReader {
    private AudioFile audioFile;
    private boolean isMp3File;

    AudioFileMPlayerOutputReader(MPlayerEngine mPlayerEngine, Process process, AudioFile audioFile) {
        super(mPlayerEngine, process);
        this.audioFile = audioFile;
        this.isMp3File = AudioFile.isValidAudioFile(audioFile.getFile(), Format.MP3);
    }

    @Override
    protected void init() {
        super.init();
    }

    @Override
    protected void read(String string) {
        super.read(string);
        this.readAndApplyLength(this.audioFile, string, this.isMp3File);
        if (this.getEngine().isMute() && this.getLength() > 0 && this.getLength() - this.getTime() < 2000) {
            this.getLogger().debug("PLAYER      ", "MPlayer 'mute bug' workaround applied");
            this.getEngine().currentAudioObjectFinished(true, new String[0]);
            this.interrupt();
        }
    }
}

