/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.navigator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTreeCellDecorator;
import net.sourceforge.atunes.gui.views.controls.NavigationTree;
import net.sourceforge.atunes.gui.views.decorators.AlbumTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.ArtistTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.FolderTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.GenreTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.IncompleteTagsTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.StringTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.TooltipTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.UnknownElementTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.YearTreeCellDecorator;
import net.sourceforge.atunes.gui.views.menus.EditTagMenu;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.AddToPlayListAction;
import net.sourceforge.atunes.kernel.actions.AddToPlayListAfterCurrentAudioObjectAction;
import net.sourceforge.atunes.kernel.actions.CopyToDeviceAction;
import net.sourceforge.atunes.kernel.actions.EditTitlesAction;
import net.sourceforge.atunes.kernel.actions.ExtractPictureAction;
import net.sourceforge.atunes.kernel.actions.OpenFolderFromNavigatorAction;
import net.sourceforge.atunes.kernel.actions.PlayNowAction;
import net.sourceforge.atunes.kernel.actions.RemoveFromDiskAction;
import net.sourceforge.atunes.kernel.actions.RenameAudioFileInNavigationTableAction;
import net.sourceforge.atunes.kernel.actions.SearchArtistAction;
import net.sourceforge.atunes.kernel.actions.SearchArtistAtAction;
import net.sourceforge.atunes.kernel.actions.SetAsPlayListAction;
import net.sourceforge.atunes.kernel.actions.SetFavoriteAlbumFromNavigatorAction;
import net.sourceforge.atunes.kernel.actions.SetFavoriteArtistFromNavigatorAction;
import net.sourceforge.atunes.kernel.actions.SetFavoriteSongFromNavigatorAction;
import net.sourceforge.atunes.kernel.actions.ShowNavigatorTableItemInfoAction;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumnSet;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractNavigationView;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.TreeObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class RepositoryNavigationView
extends AbstractNavigationView {
    private JTree tree;
    private JPopupMenu treePopupMenu;
    private JPopupMenu tablePopupMenu;
    private List<AbstractTreeCellDecorator> decorators;

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("audioFile_little.png");
    }

    @Override
    public String getTitle() {
        return I18nUtils.getString("REPOSITORY");
    }

    @Override
    public String getTooltip() {
        return I18nUtils.getString("REPOSITORY_TAB_TOOLTIP");
    }

    @Override
    public JTree getTree() {
        if (this.tree == null) {
            this.tree = new NavigationTree(new DefaultTreeModel(new DefaultMutableTreeNode(I18nUtils.getString("REPOSITORY"))));
            this.tree.setToggleClickCount(0);
            this.tree.setCellRenderer(this.getTreeRenderer());
            ToolTipManager.sharedInstance().registerComponent(this.tree);
        }
        return this.tree;
    }

    @Override
    public JPopupMenu getTreePopupMenu() {
        if (this.treePopupMenu == null) {
            this.treePopupMenu = new JPopupMenu();
            this.treePopupMenu.add(this.getMenuItemForAction(AddToPlayListAction.class));
            this.treePopupMenu.add(this.getMenuItemForAction(SetAsPlayListAction.class));
            this.treePopupMenu.add(new JSeparator());
            this.treePopupMenu.add(this.getMenuItemForAction(OpenFolderFromNavigatorAction.class));
            this.treePopupMenu.add(new JSeparator());
            this.treePopupMenu.add(new EditTagMenu(false, this));
            this.treePopupMenu.add(Actions.getAction(EditTitlesAction.class));
            this.treePopupMenu.add(new JSeparator());
            this.treePopupMenu.add(Actions.getAction(RemoveFromDiskAction.class));
            this.treePopupMenu.add(new JSeparator());
            this.treePopupMenu.add(this.getMenuItemForAction(CopyToDeviceAction.class));
            this.treePopupMenu.add(new JSeparator());
            this.treePopupMenu.add(this.getMenuItemForAction(SetFavoriteAlbumFromNavigatorAction.class));
            this.treePopupMenu.add(this.getMenuItemForAction(SetFavoriteArtistFromNavigatorAction.class));
            this.treePopupMenu.add(new JSeparator());
            this.treePopupMenu.add(Actions.getAction(SearchArtistAction.class));
            this.treePopupMenu.add(Actions.getAction(SearchArtistAtAction.class));
        }
        return this.treePopupMenu;
    }

    @Override
    public JPopupMenu getTablePopupMenu() {
        if (this.tablePopupMenu == null) {
            this.tablePopupMenu = new JPopupMenu();
            this.tablePopupMenu.add(this.getMenuItemForAction(AddToPlayListAction.class));
            this.tablePopupMenu.add(this.getMenuItemForAction(AddToPlayListAfterCurrentAudioObjectAction.class));
            this.tablePopupMenu.add(this.getMenuItemForAction(SetAsPlayListAction.class));
            this.tablePopupMenu.add(Actions.getAction(PlayNowAction.class));
            this.tablePopupMenu.add(new JSeparator());
            this.tablePopupMenu.add(Actions.getAction(ShowNavigatorTableItemInfoAction.class));
            this.tablePopupMenu.add(new JSeparator());
            this.tablePopupMenu.add(this.getMenuItemForAction(OpenFolderFromNavigatorAction.class));
            this.tablePopupMenu.add(new JSeparator());
            this.tablePopupMenu.add(new EditTagMenu(false, this));
            this.tablePopupMenu.add(this.getMenuItemForAction(ExtractPictureAction.class));
            this.tablePopupMenu.add(new JSeparator());
            this.tablePopupMenu.add(Actions.getAction(RemoveFromDiskAction.class));
            this.tablePopupMenu.add(Actions.getAction(RenameAudioFileInNavigationTableAction.class));
            this.tablePopupMenu.add(new JSeparator());
            this.tablePopupMenu.add(this.getMenuItemForAction(CopyToDeviceAction.class));
            this.tablePopupMenu.add(new JSeparator());
            this.tablePopupMenu.add(this.getMenuItemForAction(SetFavoriteSongFromNavigatorAction.class));
        }
        return this.tablePopupMenu;
    }

    @Override
    protected Map<String, ?> getViewData(NavigationController.ViewMode viewMode) {
        if (viewMode == NavigationController.ViewMode.YEAR) {
            return RepositoryHandler.getInstance().getYearStructure();
        }
        if (viewMode == NavigationController.ViewMode.GENRE) {
            return RepositoryHandler.getInstance().getGenreStructure();
        }
        if (viewMode == NavigationController.ViewMode.FOLDER) {
            return RepositoryHandler.getInstance().getFolderStructure();
        }
        if (viewMode == NavigationController.ViewMode.ALBUM) {
            return RepositoryHandler.getInstance().getAlbumStructure();
        }
        return RepositoryHandler.getInstance().getArtistStructure();
    }

    @Override
    protected void refreshTree(NavigationController.ViewMode viewMode, String string) {
        this.debug("Refreshing ", this.getClass().getName());
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTree().getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        List<TreeObject> list = RepositoryNavigationView.getTreeObjectsSelected(this.tree);
        List<TreeObject> list2 = RepositoryNavigationView.getTreeObjectsExpanded(this.tree, defaultMutableTreeNode);
        viewMode.getTreeGenerator().buildTree("REPOSITORY", this, this.getViewData(viewMode), string, defaultMutableTreeNode, defaultTreeModel, list, list2);
        this.getTree().expandRow(0);
    }

    @Override
    public List<AudioObject> getAudioObjectForTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, NavigationController.ViewMode viewMode, String string) {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioFile>();
        if (defaultMutableTreeNode.isRoot()) {
            if (string == null) {
                arrayList.addAll(RepositoryHandler.getInstance().getAudioFilesList());
            } else {
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    TreeObject treeObject = (TreeObject)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getUserObject();
                    arrayList.addAll(treeObject.getAudioObjects());
                }
            }
        } else {
            TreeObject treeObject = (TreeObject)defaultMutableTreeNode.getUserObject();
            arrayList = treeObject.getAudioObjects();
        }
        return arrayList;
    }

    @Override
    public boolean isUseDefaultNavigatorColumnSet() {
        return true;
    }

    @Override
    public AbstractColumnSet getCustomColumnSet() {
        return null;
    }

    @Override
    public boolean isViewModeSupported() {
        return true;
    }

    @Override
    protected List<AbstractTreeCellDecorator> getTreeCellDecorators() {
        if (this.decorators == null) {
            this.decorators = new ArrayList<AbstractTreeCellDecorator>();
            this.decorators.add(new ArtistTreeCellDecorator());
            this.decorators.add(new AlbumTreeCellDecorator());
            this.decorators.add(new GenreTreeCellDecorator());
            this.decorators.add(new YearTreeCellDecorator());
            this.decorators.add(new FolderTreeCellDecorator());
            this.decorators.add(new StringTreeCellDecorator());
            this.decorators.add(new TooltipTreeCellDecorator());
            this.decorators.add(new UnknownElementTreeCellDecorator());
            this.decorators.add(new IncompleteTagsTreeCellDecorator());
        }
        return this.decorators;
    }

    static String getToolTipForRepository() {
        int n = RepositoryHandler.getInstance().getAudioFilesList().size();
        return StringUtils.getString(I18nUtils.getString("REPOSITORY"), " (", n, " ", n > 1 ? I18nUtils.getString("SONGS") : I18nUtils.getString("SONG"), ")");
    }
}

