/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTreeCellDecorator;
import net.sourceforge.atunes.gui.views.controls.NavigationTree;
import net.sourceforge.atunes.gui.views.decorators.AlbumTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.ArtistTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.IncompleteTagsTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.StringTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.UnknownElementTreeCellDecorator;
import net.sourceforge.atunes.gui.views.menus.EditTagMenu;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.AddToPlayListAction;
import net.sourceforge.atunes.kernel.actions.AddToPlayListAfterCurrentAudioObjectAction;
import net.sourceforge.atunes.kernel.actions.CopyToDeviceAction;
import net.sourceforge.atunes.kernel.actions.EditTitlesAction;
import net.sourceforge.atunes.kernel.actions.ExtractPictureAction;
import net.sourceforge.atunes.kernel.actions.OpenFolderFromNavigatorAction;
import net.sourceforge.atunes.kernel.actions.PlayNowAction;
import net.sourceforge.atunes.kernel.actions.RemoveFromDiskAction;
import net.sourceforge.atunes.kernel.actions.RemoveFromFavoritesAction;
import net.sourceforge.atunes.kernel.actions.RenameAudioFileInNavigationTableAction;
import net.sourceforge.atunes.kernel.actions.SearchArtistAction;
import net.sourceforge.atunes.kernel.actions.SearchArtistAtAction;
import net.sourceforge.atunes.kernel.actions.SetAsPlayListAction;
import net.sourceforge.atunes.kernel.actions.ShowNavigatorTableItemInfoAction;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumnSet;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractNavigationView;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.favorites.FavoritesHandler;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.TreeObject;
import net.sourceforge.atunes.utils.I18nUtils;

public final class FavoritesNavigationView
extends AbstractNavigationView {
    private List<AbstractTreeCellDecorator> decorators;
    private JTree favoritesTree;
    private JPopupMenu favoriteTreeMenu;
    private JPopupMenu favoriteTableMenu;

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("favorite.png");
    }

    @Override
    public String getTitle() {
        return I18nUtils.getString("FAVORITES");
    }

    @Override
    public String getTooltip() {
        return I18nUtils.getString("FAVORITES_TAB_TOOLTIP");
    }

    @Override
    public JTree getTree() {
        if (this.favoritesTree == null) {
            this.favoritesTree = new NavigationTree(new DefaultTreeModel(new DefaultMutableTreeNode(I18nUtils.getString("FAVORITES"))));
            this.favoritesTree.setToggleClickCount(0);
            this.favoritesTree.setCellRenderer(this.getTreeRenderer());
        }
        return this.favoritesTree;
    }

    @Override
    public JPopupMenu getTreePopupMenu() {
        if (this.favoriteTreeMenu == null) {
            this.favoriteTreeMenu = new JPopupMenu();
            this.favoriteTreeMenu.add(this.getMenuItemForAction(AddToPlayListAction.class));
            this.favoriteTreeMenu.add(this.getMenuItemForAction(SetAsPlayListAction.class));
            this.favoriteTreeMenu.add(new JSeparator());
            this.favoriteTreeMenu.add(this.getMenuItemForAction(OpenFolderFromNavigatorAction.class));
            this.favoriteTreeMenu.add(new JSeparator());
            this.favoriteTreeMenu.add(new EditTagMenu(false, this));
            this.favoriteTreeMenu.add(Actions.getAction(EditTitlesAction.class));
            this.favoriteTreeMenu.add(new JSeparator());
            this.favoriteTreeMenu.add(Actions.getAction(RemoveFromDiskAction.class));
            this.favoriteTreeMenu.add(new JSeparator());
            this.favoriteTreeMenu.add(this.getMenuItemForAction(CopyToDeviceAction.class));
            this.favoriteTreeMenu.add(new JSeparator());
            this.favoriteTreeMenu.add(Actions.getAction(RemoveFromFavoritesAction.class));
            this.favoriteTreeMenu.add(new JSeparator());
            this.favoriteTreeMenu.add(Actions.getAction(SearchArtistAction.class));
            this.favoriteTreeMenu.add(Actions.getAction(SearchArtistAtAction.class));
        }
        return this.favoriteTreeMenu;
    }

    @Override
    public JPopupMenu getTablePopupMenu() {
        if (this.favoriteTableMenu == null) {
            this.favoriteTableMenu = new JPopupMenu();
            this.favoriteTableMenu.add(this.getMenuItemForAction(AddToPlayListAction.class));
            this.favoriteTableMenu.add(this.getMenuItemForAction(AddToPlayListAfterCurrentAudioObjectAction.class));
            this.favoriteTableMenu.add(this.getMenuItemForAction(SetAsPlayListAction.class));
            this.favoriteTableMenu.add(Actions.getAction(PlayNowAction.class));
            this.favoriteTableMenu.add(new JSeparator());
            this.favoriteTableMenu.add(Actions.getAction(ShowNavigatorTableItemInfoAction.class));
            this.favoriteTableMenu.add(new JSeparator());
            this.favoriteTableMenu.add(this.getMenuItemForAction(OpenFolderFromNavigatorAction.class));
            this.favoriteTableMenu.add(new JSeparator());
            this.favoriteTableMenu.add(new EditTagMenu(false, this));
            this.favoriteTableMenu.add(this.getMenuItemForAction(ExtractPictureAction.class));
            this.favoriteTableMenu.add(new JSeparator());
            this.favoriteTableMenu.add(Actions.getAction(RemoveFromDiskAction.class));
            this.favoriteTableMenu.add(Actions.getAction(RenameAudioFileInNavigationTableAction.class));
            this.favoriteTableMenu.add(new JSeparator());
            this.favoriteTableMenu.add(this.getMenuItemForAction(CopyToDeviceAction.class));
            this.favoriteTableMenu.add(new JSeparator());
            this.favoriteTableMenu.add(Actions.getAction(RemoveFromFavoritesAction.class));
        }
        return this.favoriteTableMenu;
    }

    @Override
    public Map<String, ?> getViewData(NavigationController.ViewMode viewMode) {
        HashMap<String, Map<String, Comparable<Artist>>> hashMap = new HashMap<String, Map<String, Comparable<Artist>>>();
        hashMap.put("ARTISTS", FavoritesHandler.getInstance().getFavoriteArtistsInfo());
        hashMap.put("ALBUMS", FavoritesHandler.getInstance().getFavoriteAlbumsInfo());
        return hashMap;
    }

    @Override
    protected void refreshTree(NavigationController.ViewMode viewMode, String string) {
        this.debug("Refreshing ", this.getClass().getName());
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTree().getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        List<TreeObject> list = FavoritesNavigationView.getTreeObjectsSelected(this.getTree());
        List<TreeObject> list2 = FavoritesNavigationView.getTreeObjectsExpanded(this.getTree(), defaultMutableTreeNode);
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<DefaultMutableTreeNode> arrayList2 = new ArrayList<DefaultMutableTreeNode>();
        Map<String, ?> map = this.getViewData(viewMode);
        defaultMutableTreeNode.setUserObject(I18nUtils.getString("FAVORITES"));
        defaultMutableTreeNode.removeAllChildren();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
        defaultMutableTreeNode2.setUserObject(I18nUtils.getString("ARTISTS"));
        arrayList2.add(defaultMutableTreeNode2);
        FavoritesNavigationView.addArtistNodes(defaultMutableTreeNode2, string, (Map)map.get("ARTISTS"), list, list2, arrayList, arrayList2);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode();
        defaultMutableTreeNode3.setUserObject(I18nUtils.getString("ALBUMS"));
        arrayList2.add(defaultMutableTreeNode3);
        FavoritesNavigationView.addAlbumNodes(defaultMutableTreeNode3, string, (Map)map.get("ALBUMS"), list, list2, arrayList, arrayList2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode();
        defaultMutableTreeNode4.setUserObject(I18nUtils.getString("SONGS"));
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultTreeModel.reload();
        FavoritesNavigationView.expandNodes(this.getTree(), arrayList2);
        FavoritesNavigationView.selectNodes(this.getTree(), arrayList);
    }

    @Override
    public List<AudioObject> getAudioObjectForTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, NavigationController.ViewMode viewMode, String string) {
        ArrayList<AudioObject> arrayList = null;
        if (defaultMutableTreeNode.isRoot()) {
            arrayList = new ArrayList<AudioFile>();
            arrayList.addAll(RepositoryHandler.getInstance().getAudioFilesForArtists(FavoritesHandler.getInstance().getFavoriteArtistsInfo()));
            arrayList.addAll(RepositoryHandler.getInstance().getAudioFilesForAlbums(FavoritesHandler.getInstance().getFavoriteAlbumsInfo()));
            arrayList.addAll(FavoritesHandler.getInstance().getFavoriteSongsInfo().values());
        } else if (defaultMutableTreeNode.getUserObject() instanceof TreeObject) {
            arrayList = ((TreeObject)defaultMutableTreeNode.getUserObject()).getAudioObjects();
        } else {
            arrayList = new ArrayList();
            if (defaultMutableTreeNode.getUserObject().toString().equals(I18nUtils.getString("ARTISTS"))) {
                arrayList.addAll(RepositoryHandler.getInstance().getAudioFilesForArtists(FavoritesHandler.getInstance().getFavoriteArtistsInfo()));
            } else if (defaultMutableTreeNode.getUserObject().toString().equals(I18nUtils.getString("ALBUMS"))) {
                arrayList.addAll(RepositoryHandler.getInstance().getAudioFilesForAlbums(FavoritesHandler.getInstance().getFavoriteAlbumsInfo()));
            } else {
                arrayList.addAll(new ArrayList<AudioFile>(FavoritesHandler.getInstance().getFavoriteSongsInfo().values()));
            }
        }
        return arrayList;
    }

    private static void addAlbumNodes(DefaultMutableTreeNode defaultMutableTreeNode, String string, Map<String, Album> map, List<TreeObject> list, List<TreeObject> list2, List<DefaultMutableTreeNode> list3, List<DefaultMutableTreeNode> list4) {
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Album album = map.get(arrayList.get(i));
            if (string != null && !album.getName().toUpperCase().contains(string.toUpperCase())) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(album);
            if (list.contains(defaultMutableTreeNode2.getUserObject())) {
                list3.add(defaultMutableTreeNode2);
            }
            if (list2.contains(defaultMutableTreeNode2.getUserObject())) {
                list4.add(defaultMutableTreeNode2);
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private static void addArtistNodes(DefaultMutableTreeNode defaultMutableTreeNode, String string, Map<String, Artist> map, List<TreeObject> list, List<TreeObject> list2, List<DefaultMutableTreeNode> list3, List<DefaultMutableTreeNode> list4) {
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Artist artist = map.get(arrayList.get(i));
            if (string != null && !artist.getName().toUpperCase().contains(string.toUpperCase())) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(artist);
            if (list.contains(defaultMutableTreeNode2.getUserObject())) {
                list3.add(defaultMutableTreeNode2);
            }
            if (list2.contains(defaultMutableTreeNode2.getUserObject())) {
                list4.add(defaultMutableTreeNode2);
            }
            FavoritesNavigationView.addAlbumNodes(defaultMutableTreeNode2, null, artist.getAlbums(), list, list2, list3, list4);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    @Override
    public boolean isUseDefaultNavigatorColumnSet() {
        return true;
    }

    @Override
    public AbstractColumnSet getCustomColumnSet() {
        return null;
    }

    @Override
    public boolean isViewModeSupported() {
        return false;
    }

    @Override
    protected List<AbstractTreeCellDecorator> getTreeCellDecorators() {
        if (this.decorators == null) {
            this.decorators = new ArrayList<AbstractTreeCellDecorator>();
            this.decorators.add(new ArtistTreeCellDecorator());
            this.decorators.add(new AlbumTreeCellDecorator());
            this.decorators.add(new StringTreeCellDecorator());
            this.decorators.add(new UnknownElementTreeCellDecorator());
            this.decorators.add(new IncompleteTagsTreeCellDecorator());
        }
        return this.decorators;
    }
}

