/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.navigator;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTreeCellDecorator;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTreeCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.model.AudioObjectsSource;
import net.sourceforge.atunes.gui.model.NavigationTableModel;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumnSet;
import net.sourceforge.atunes.kernel.modules.filter.FilterHandler;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.repository.AudioObjectComparator;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.TreeObject;

public abstract class AbstractNavigationView
implements AudioObjectsSource {
    private Logger logger;
    private JScrollPane scrollPane;

    public abstract String getTitle();

    public abstract ImageIcon getIcon();

    public abstract String getTooltip();

    public abstract JTree getTree();

    protected abstract List<AbstractTreeCellDecorator> getTreeCellDecorators();

    public abstract JPopupMenu getTreePopupMenu();

    public JPopupMenu getTablePopupMenu() {
        return this.getTreePopupMenu();
    }

    public final JScrollPane getTreeScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getTree());
        }
        return this.scrollPane;
    }

    protected abstract Map<String, ?> getViewData(NavigationController.ViewMode var1);

    public void refreshView(NavigationController.ViewMode viewMode, String string) {
        List<AudioObject> list = ((NavigationTableModel)this.getNavigationTable().getModel()).getAudioObjectsAt(this.getNavigationTable().getSelectedRows());
        this.refreshTree(viewMode, string);
        for (AudioObject audioObject : list) {
            int n = ((NavigationTableModel)this.getNavigationTable().getModel()).getAudioObjects().indexOf(audioObject);
            if (n == -1) continue;
            this.getNavigationTable().addRowSelectionInterval(n, n);
        }
    }

    protected abstract void refreshTree(NavigationController.ViewMode var1, String var2);

    public abstract List<AudioObject> getAudioObjectForTreeNode(DefaultMutableTreeNode var1, NavigationController.ViewMode var2, String var3);

    public abstract boolean isViewModeSupported();

    public abstract boolean isUseDefaultNavigatorColumnSet();

    public abstract AbstractColumnSet getCustomColumnSet();

    public final void updateTreePopupMenuWithTreeSelection(MouseEvent mouseEvent) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        TreePath[] treePathArray = this.getTree().getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            for (TreePath treePath : treePathArray) {
                arrayList.add((DefaultMutableTreeNode)treePath.getLastPathComponent());
            }
        }
        this.updateTreePopupMenuItems(this.getTreePopupMenu(), this.getTree().isRowSelected(0), arrayList);
    }

    private void updateTreePopupMenuItems(JPopupMenu jPopupMenu, boolean bl, List<DefaultMutableTreeNode> list) {
        for (Component component : jPopupMenu.getComponents()) {
            Action action = null;
            if (component instanceof JMenuItem) {
                action = ((JMenuItem)component).getAction();
            }
            if (component instanceof JMenu) {
                this.updateTreeMenuItems((JMenu)component, bl, list);
            }
            if (!(action instanceof AbstractAction)) continue;
            boolean bl2 = ((AbstractAction)action).isEnabledForNavigationTreeSelection(bl, list);
            action.setEnabled(bl2);
        }
    }

    private void updateTreeMenuItems(JMenu jMenu, boolean bl, List<DefaultMutableTreeNode> list) {
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            Action action = jMenuItem.getAction();
            if (jMenuItem instanceof JMenu) {
                this.updateTreeMenuItems((JMenu)jMenuItem, bl, list);
            }
            if (!(action instanceof AbstractAction)) continue;
            boolean bl2 = ((AbstractAction)action).isEnabledForNavigationTreeSelection(bl, list);
            action.setEnabled(bl2);
        }
    }

    public final void updateTablePopupMenuWithTableSelection(JTable jTable, MouseEvent mouseEvent) {
        this.updateTablePopupMenuItems(this.getTablePopupMenu(), ((NavigationTableModel)this.getNavigationTable().getModel()).getAudioObjectsAt(jTable.getSelectedRows()));
    }

    private void updateTablePopupMenuItems(JPopupMenu jPopupMenu, List<AudioObject> list) {
        for (Component component : jPopupMenu.getComponents()) {
            Action action = null;
            if (component instanceof JMenuItem) {
                action = ((JMenuItem)component).getAction();
            }
            if (component instanceof JMenu) {
                this.updateTableMenuItems((JMenu)component, list);
            }
            if (!(action instanceof AbstractAction)) continue;
            boolean bl = ((AbstractAction)action).isEnabledForNavigationTableSelection(list);
            action.setEnabled(bl);
        }
    }

    private void updateTableMenuItems(JMenu jMenu, List<AudioObject> list) {
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            Action action = jMenuItem.getAction();
            if (jMenuItem instanceof JMenu) {
                this.updateTableMenuItems((JMenu)jMenuItem, list);
            }
            if (!(action instanceof AbstractAction)) continue;
            boolean bl = ((AbstractAction)action).isEnabledForNavigationTableSelection(list);
            action.setEnabled(bl);
        }
    }

    protected final void debug(Object ... objectArray) {
        this.getLogger().debug("VIEW        ", objectArray);
    }

    protected JTable getNavigationTable() {
        return ControllerProxy.getInstance().getNavigationController().getNavigationTablePanel().getNavigationTable();
    }

    public Comparator<String> getDefaultComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return AbstractNavigationView.this.getCollator().compare(string.toLowerCase(), string2.toLowerCase());
            }
        };
    }

    public Comparator<String> getIntegerComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n;
                if (string == null || string2 == null) {
                    return 0;
                }
                try {
                    n = Integer.valueOf(string).compareTo(Integer.valueOf(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                return n;
            }
        };
    }

    public NavigationController.ViewMode getCurrentViewMode() {
        return ApplicationState.getInstance().getViewMode();
    }

    @Override
    public List<AudioObject> getSelectedAudioObjects() {
        List<AudioObject> list = ((NavigationTableModel)this.getNavigationTable().getModel()).getAudioObjectsAt(this.getNavigationTable().getSelectedRows());
        if (list.isEmpty()) {
            TreePath[] treePathArray = this.getTree().getSelectionPaths();
            ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
            if (treePathArray != null) {
                for (TreePath treePath : treePathArray) {
                    arrayList.addAll(this.getAudioObjectForTreeNode((DefaultMutableTreeNode)treePath.getLastPathComponent(), this.getCurrentViewMode(), FilterHandler.getInstance().isFilterSelected(NavigationHandler.getInstance().getTreeFilter()) ? FilterHandler.getInstance().getFilter() : null));
                    AudioObjectComparator.sort(arrayList);
                }
            }
            return arrayList;
        }
        return list;
    }

    protected JMenuItem getMenuItemForAction(Class<? extends AbstractActionOverSelectedObjects<? extends AudioObject>> clazz) {
        return Actions.getMenuItemForAction(clazz, this);
    }

    protected JMenuItem getMenuItemForAction(Class<? extends AbstractActionOverSelectedObjects<? extends AudioObject>> clazz, String string) {
        return Actions.getMenuItemForAction(clazz, string, this);
    }

    protected static final List<TreeObject> getTreeObjectsSelected(JTree jTree) {
        ArrayList<TreeObject> arrayList = new ArrayList<TreeObject>();
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                if (!(object instanceof TreeObject)) continue;
                arrayList.add((TreeObject)object);
            }
        }
        return arrayList;
    }

    protected static final List<TreeObject> getTreeObjectsExpanded(JTree jTree, DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<TreeObject> arrayList = new ArrayList<TreeObject>();
        Enumeration<TreePath> enumeration = jTree.getExpandedDescendants(new TreePath(defaultMutableTreeNode.getPath()));
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath treePath = enumeration.nextElement();
                Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                if (!(object instanceof TreeObject)) continue;
                arrayList.add((TreeObject)object);
            }
        }
        return arrayList;
    }

    protected static final void expandNodes(JTree jTree, List<DefaultMutableTreeNode> list) {
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            jTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    protected static final void selectNodes(JTree jTree, List<DefaultMutableTreeNode> list) {
        if (list.isEmpty()) {
            jTree.setSelectionRow(0);
        } else {
            TreePath[] treePathArray = new TreePath[list.size()];
            int n = 0;
            for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
                treePathArray[n++] = new TreePath(defaultMutableTreeNode.getPath());
            }
            jTree.setSelectionPaths(treePathArray);
        }
    }

    public final AbstractAction getActionToShowView(int n) {
        AbstractAction abstractAction = new AbstractAction(this.getTitle(), this.getIcon()){
            private static final long serialVersionUID = 2895222205333520899L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControllerProxy.getInstance().getNavigationController().setNavigationView(AbstractNavigationView.this.getClass().getName());
            }
        };
        if (n > 0 && n < 10) {
            abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(48 + n, 8));
        }
        return abstractAction;
    }

    protected final TreeCellRenderer getTreeRenderer() {
        return LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTreeCellRenderer(new AbstractTreeCellRendererCode(){

            @Override
            public Component getComponent(Component component, JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                for (AbstractTreeCellDecorator abstractTreeCellDecorator : AbstractNavigationView.this.getTreeCellDecorators()) {
                    abstractTreeCellDecorator.decorateTreeCellComponent(component, object2);
                }
                return component;
            }
        });
    }

    protected Collator getCollator() {
        return Collator.getInstance(ApplicationState.getInstance().getLocale().getLocale());
    }

    protected Comparator<String> getSmartComparator() {
        return new Comparator<String>(){

            private String removeThe(String string) {
                if (string.toLowerCase().startsWith("the ") && string.length() > 4) {
                    return string.substring(4);
                }
                return string;
            }

            @Override
            public int compare(String string, String string2) {
                return AbstractNavigationView.this.getCollator().compare(this.removeThe(string).toLowerCase(), this.removeThe(string2).toLowerCase());
            }
        };
    }

    protected Comparator<String> getArtistNamesComparator() {
        return new ArtistNamesComparator();
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private final class ArtistNamesComparator
    implements Comparator<String> {
        private final Pattern PATTERN = Pattern.compile("(.*)\\s+(.*?)");

        private ArtistNamesComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            String[] stringArray = string.split("[,\\&]");
            String[] stringArray2 = string2.split("[,\\&]");
            String string3 = this.getStringForSorting(string, stringArray);
            String string4 = this.getStringForSorting(string2, stringArray2);
            return AbstractNavigationView.this.getCollator().compare(string3.toLowerCase(), string4.toLowerCase());
        }

        private String getStringForSorting(String string, String[] stringArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray) {
                Matcher matcher = this.PATTERN.matcher(string2.trim());
                String string3 = string;
                String string4 = "";
                if (matcher.matches()) {
                    string3 = matcher.group(2);
                    string4 = matcher.group(1);
                }
                stringBuilder.append(string3);
                stringBuilder.append(string4);
            }
            return stringBuilder.toString();
        }
    }
}

