/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.internetsearch;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.atunes.kernel.modules.internetsearch.Search;
import net.sourceforge.atunes.utils.StringUtils;

public final class SearchFactory {
    private static HashMap<String, Search> searches;
    private static Search youTubeSearch;
    private static Search wikipediaENSearch;
    private static Search freeDBSearch;
    private static Search musicBrainzSearch;
    private static Search googleVideoSearch;

    private SearchFactory() {
    }

    public static List<Search> getSearches() {
        if (searches == null) {
            searches = new HashMap();
            searches.put(((Object)freeDBSearch).toString(), freeDBSearch);
            searches.put(((Object)googleVideoSearch).toString(), googleVideoSearch);
            searches.put(((Object)musicBrainzSearch).toString(), musicBrainzSearch);
            searches.put(((Object)wikipediaENSearch).toString(), wikipediaENSearch);
            searches.put(((Object)youTubeSearch).toString(), youTubeSearch);
        }
        return new ArrayList<Search>(searches.values());
    }

    public static Search getSearchForName(String string) {
        if (searches == null) {
            SearchFactory.getSearches();
        }
        return searches.get(string);
    }

    static {
        youTubeSearch = new Search(){

            @Override
            public URL getURL(String string) throws MalformedURLException {
                String string2 = string.replaceAll(" +", "+");
                return new URL(StringUtils.getString("http://www.youtube.com/results?search_query=", string2, "&search=Search"));
            }

            @Override
            public String toString() {
                return "YouTube";
            }
        };
        wikipediaENSearch = new Search(){

            @Override
            public URL getURL(String string) throws MalformedURLException {
                String string2 = string.replaceAll(" +", "_");
                return new URL(StringUtils.getString("http://en.wikipedia.org/wiki/", string2));
            }

            @Override
            public String toString() {
                return "Wikipedia (English)";
            }
        };
        freeDBSearch = new Search(){

            @Override
            public URL getURL(String string) throws MalformedURLException {
                String string2 = string.replaceAll(" +", "+");
                return new URL(StringUtils.getString("http://www.freedb.org/freedb_search.php?words=", string2));
            }

            @Override
            public String toString() {
                return "FreeDB";
            }
        };
        musicBrainzSearch = new Search(){

            @Override
            public URL getURL(String string) throws MalformedURLException {
                String string2 = string.replaceAll(" +", "+");
                String string3 = StringUtils.getString("%22", string2, "%22");
                return new URL(StringUtils.getString("http://musicbrainz.org/search/textsearch.html?query=", string3, "&type=artist&limit=&an=1&as=1&handlearguments=1"));
            }

            @Override
            public String toString() {
                return "MusicBrainz";
            }
        };
        googleVideoSearch = new Search(){

            @Override
            public URL getURL(String string) throws MalformedURLException {
                String string2 = string.replaceAll(" +", "+");
                return new URL(StringUtils.getString("http://video.google.com/videosearch?q=", string2));
            }

            @Override
            public String toString() {
                return "Google Video";
            }
        };
    }
}

