/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.hotkeys;

import javax.swing.SwingUtilities;
import jxgrabkey.HotkeyConflictException;
import jxgrabkey.JXGrabKey;
import net.sourceforge.atunes.kernel.modules.hotkeys.AbstractHotkeys;
import net.sourceforge.atunes.kernel.modules.hotkeys.Hotkey;
import net.sourceforge.atunes.kernel.modules.hotkeys.HotkeyListener;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.StringUtils;

class X11Hotkeys
extends AbstractHotkeys
implements jxgrabkey.HotkeyListener {
    public X11Hotkeys(HotkeyListener hotkeyListener) {
        super(hotkeyListener);
        this.init();
    }

    private void init() {
        System.loadLibrary("JXGrabKey");
        JXGrabKey.setDebugOutput((boolean)false);
    }

    @Override
    public void activate() {
        JXGrabKey.getInstance().addHotkeyListener((jxgrabkey.HotkeyListener)this);
    }

    @Override
    public void cleanUp() {
        JXGrabKey.getInstance().cleanUp();
    }

    @Override
    public void deactivate() {
        JXGrabKey.getInstance().removeHotkeyListener((jxgrabkey.HotkeyListener)this);
    }

    @Override
    public boolean registerHotkey(Hotkey hotkey) {
        try {
            JXGrabKey.getInstance().registerAwtHotkey(hotkey.getId(), hotkey.getMod(), hotkey.getKey());
        }
        catch (HotkeyConflictException hotkeyConflictException) {
            new Logger().error("HOTKEYS     ", StringUtils.getString("Hotkey '", hotkey.getKeyDescription(), "' is in use by another application"));
            return false;
        }
        return true;
    }

    @Override
    public void unregisterHotkey(Hotkey hotkey) {
        JXGrabKey.getInstance().unregisterHotKey(hotkey.getId());
    }

    public void onHotkey(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                X11Hotkeys.this.getHotkeyListener().onHotKey(n);
            }
        });
    }
}

