/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.device;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.sourceforge.atunes.kernel.modules.process.AbstractAudioFileTransferProcess;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.apache.commons.io.FileUtils;

public class TransferToDeviceProcess
extends AbstractAudioFileTransferProcess {
    private String path;

    public TransferToDeviceProcess(Collection<AudioFile> collection, String string) {
        super(collection);
        this.path = string;
    }

    @Override
    public String getProgressDialogTitle() {
        return I18nUtils.getString("COPYING_TO_DEVICE");
    }

    @Override
    protected String getDestination() {
        return this.path;
    }

    @Override
    protected File transferAudioFile(File file, AudioFile audioFile, List<Exception> list) {
        String string = this.getDirectory(audioFile, file, true);
        String string2 = this.getName(audioFile, true);
        File file2 = new File(StringUtils.getString(string, SystemProperties.FILE_SEPARATOR, string2));
        try {
            FileUtils.copyFile((File)audioFile.getFile(), (File)file2);
        }
        catch (IOException iOException) {
            list.add(iOException);
        }
        return file2;
    }

    @Override
    public String getDirectory(AudioFile audioFile, File file, boolean bl) {
        return this.getDirectory(audioFile, file, bl, ApplicationState.getInstance().getDeviceFolderPathPattern());
    }

    @Override
    public String getName(AudioFile audioFile, boolean bl) {
        return this.getName(audioFile, bl, ApplicationState.getInstance().getDeviceFileNamePattern());
    }
}

