/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.device;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.gui.views.dialogs.FileSelectionDialog;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.ConnectDeviceAction;
import net.sourceforge.atunes.kernel.actions.CopyPlayListToDeviceAction;
import net.sourceforge.atunes.kernel.actions.DisconnectDeviceAction;
import net.sourceforge.atunes.kernel.actions.RefreshDeviceAction;
import net.sourceforge.atunes.kernel.actions.SynchronizeDeviceWithPlayListAction;
import net.sourceforge.atunes.kernel.modules.device.DeviceConnectionListener;
import net.sourceforge.atunes.kernel.modules.device.DeviceConnectionMonitor;
import net.sourceforge.atunes.kernel.modules.device.DeviceDisconnectionListener;
import net.sourceforge.atunes.kernel.modules.device.DeviceDisconnectionMonitor;
import net.sourceforge.atunes.kernel.modules.device.TransferToDeviceProcess;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.navigator.DeviceNavigationView;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.process.ProcessListener;
import net.sourceforge.atunes.kernel.modules.repository.AudioFilesRemovedListener;
import net.sourceforge.atunes.kernel.modules.repository.LoaderListener;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryLoader;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.data.Folder;
import net.sourceforge.atunes.kernel.modules.repository.data.Genre;
import net.sourceforge.atunes.kernel.modules.repository.data.Repository;
import net.sourceforge.atunes.kernel.modules.repository.data.Year;
import net.sourceforge.atunes.kernel.modules.search.SearchHandler;
import net.sourceforge.atunes.kernel.modules.search.searchableobjects.DeviceSearchableObject;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.ApplicationStateHandler;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class DeviceHandler
extends AbstractHandler
implements LoaderListener,
DeviceConnectionListener,
DeviceDisconnectionListener,
AudioFilesRemovedListener {
    private static DeviceHandler instance = new DeviceHandler();
    private Repository deviceRepository;
    private RepositoryLoader currentLoader;
    private File devicePath;
    private String deviceId;
    private int filesCopiedToDevice;

    private DeviceHandler() {
    }

    @Override
    protected void initHandler() {
        RepositoryHandler.getInstance().addAudioFilesRemovedListener(this);
    }

    @Override
    public void applicationStarted() {
        DeviceConnectionMonitor.startMonitor();
        DeviceConnectionMonitor.addListener(this);
    }

    public static DeviceHandler getInstance() {
        return instance;
    }

    public void fillWithRandomSongs(long l) {
        long l2 = l;
        DeviceHandler.getLogger().debugMethodCall("HANDLER     ", Long.toString(l2));
        List<AudioFile> list = RepositoryHandler.getInstance().getAudioFilesList();
        HashMap<Integer, AudioFile> hashMap = new HashMap<Integer, AudioFile>();
        Random random = new Random(new Date().getTime());
        long l3 = this.deviceRepository.getFolders().get(0).getFreeSpace();
        l2 = l2 >= 0L ? (l2 *= 0x100000L) : 0L;
        if (l2 > l3) {
            DeviceHandler.getLogger().debug("HANDLER     ", I18nUtils.getString("NOT_ENOUGH_SPACE_ON_DEVICE"));
            GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("NOT_ENOUGH_SPACE_ON_DEVICE"));
            return;
        }
        int n = 0;
        while (l2 < l3 && list.size() > hashMap.size()) {
            int n2 = random.nextInt(list.size());
            if (!hashMap.containsKey(n2)) {
                hashMap.put(n2, list.get(n2));
            }
            ++n;
        }
        this.copyFilesToDevice(new ArrayList<AudioFile>(hashMap.values()));
    }

    public void connectDevice() {
        FileSelectionDialog fileSelectionDialog = GuiHandler.getInstance().getFileSelectionDialog(true);
        fileSelectionDialog.setTitle(I18nUtils.getString("SELECT_DEVICE"));
        fileSelectionDialog.startDialog();
        if (!fileSelectionDialog.isCanceled()) {
            File file = fileSelectionDialog.getSelectedDir();
            GuiHandler.getInstance().showProgressBar(true, null);
            this.retrieveDevice(file);
        }
    }

    public void copyFilesToDevice(Collection<AudioFile> collection) {
        this.copyFilesToDevice(collection, null);
    }

    public void copyFilesToDevice(Collection<AudioFile> collection, ProcessListener processListener) {
        this.filesCopiedToDevice = 0;
        if (collection.isEmpty()) {
            return;
        }
        long l = 0L;
        for (AudioFile audioFile : collection) {
            l += audioFile.getFile().length();
        }
        long l2 = this.deviceRepository.getFolders().get(0).getFreeSpace();
        if (l > l2) {
            GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("NOT_ENOUGH_SPACE_ON_DEVICE"));
            return;
        }
        final TransferToDeviceProcess transferToDeviceProcess = new TransferToDeviceProcess(collection, this.deviceRepository.getFolders().get(0).getAbsolutePath());
        transferToDeviceProcess.addProcessListener(new ProcessListener(){

            @Override
            public void processCanceled() {
            }

            @Override
            public void processFinished(final boolean bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DeviceHandler.this.refreshDevice();
                        DeviceHandler.this.filesCopiedToDevice = transferToDeviceProcess.getFilesTransferred().size();
                        if (!bl) {
                            GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("ERRORS_IN_EXPORT_PROCESS"));
                        }
                    }
                });
            }
        });
        if (processListener != null) {
            transferToDeviceProcess.addProcessListener(processListener);
        }
        transferToDeviceProcess.execute();
    }

    @Override
    public void deviceConnected(String string) {
        if (GuiHandler.getInstance().showConfirmationDialog(I18nUtils.getString("DEVICE_CONNECT_CONFIRMATION"), I18nUtils.getString("DEVICE_DETECTED")) == 0) {
            GuiHandler.getInstance().showProgressBar(true, null);
            this.retrieveDevice(new File(string));
        }
    }

    @Override
    public void deviceDisconnected(String string) {
        GuiHandler.getInstance().showMessage(I18nUtils.getString("DEVICE_DISCONNECTION_DETECTED"));
        this.disconnectDevice();
        DeviceConnectionMonitor.startMonitor();
    }

    public void disconnectDevice() {
        ApplicationStateHandler.getInstance().persistDeviceCache(this.deviceId, this.deviceRepository);
        GuiHandler.getInstance().hideDeviceInfoOnStatusBar();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (AudioObject audioObject : PlayListHandler.getInstance().getCurrentPlayList(true).getObjectsOfType(AudioFile.class)) {
            AudioFile audioFile = (AudioFile)audioObject;
            if (!audioFile.getFile().getPath().startsWith(this.getDeviceRepository().getFolders().get(0).getPath())) continue;
            arrayList.add(PlayListHandler.getInstance().getCurrentPlayList(true).indexOf(audioFile));
        }
        Object object = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        if (((Object)object).length > 0) {
            GuiHandler.getInstance().getPlayListPanel().getPlayListTable().getSelectionModel().clearSelection();
            PlayListHandler.getInstance().removeAudioObjects((int[])object);
        }
        this.deviceRepository = null;
        this.notifyFinishRefresh(null);
        DeviceHandler.getLogger().info("REPOSITORY  ", "Device disconnected");
        Actions.getAction(ConnectDeviceAction.class).setEnabled(true);
        Actions.getAction(RefreshDeviceAction.class).setEnabled(false);
        Actions.getAction(DisconnectDeviceAction.class).setEnabled(false);
        Actions.getAction(SynchronizeDeviceWithPlayListAction.class).setEnabled(false);
        Actions.getAction(CopyPlayListToDeviceAction.class).setEnabled(false);
        SearchHandler.getInstance().unregisterSearchableObject(DeviceSearchableObject.getInstance());
    }

    @Override
    public void applicationFinish() {
        if (this.isDeviceConnected()) {
            ApplicationStateHandler.getInstance().persistDeviceCache(this.deviceId, this.deviceRepository);
        }
    }

    public Map<String, Artist> getDeviceArtistStructure() {
        if (this.deviceRepository != null) {
            return this.deviceRepository.getArtistStructure();
        }
        return new HashMap<String, Artist>();
    }

    public Map<String, Album> getDeviceAlbumStructure() {
        if (this.deviceRepository != null) {
            HashMap<String, Album> hashMap = new HashMap<String, Album>();
            Collection<Artist> collection = this.deviceRepository.getArtistStructure().values();
            for (Artist artist : collection) {
                for (Album album : artist.getAlbums().values()) {
                    hashMap.put(album.getNameAndArtist(), album);
                }
            }
            return hashMap;
        }
        return new HashMap<String, Album>();
    }

    public Map<String, Genre> getDeviceGenreStructure() {
        if (this.deviceRepository != null) {
            return this.deviceRepository.getGenreStructure();
        }
        return new HashMap<String, Genre>();
    }

    private String getDeviceData() {
        if (this.deviceRepository != null) {
            int n = this.deviceRepository.countFiles();
            File file = this.deviceRepository.getFolders().get(0);
            return StringUtils.getString(Integer.toString(n), " ", I18nUtils.getString("SONGS"), "  (", I18nUtils.getString("FREE_SPACE"), ": ", StringUtils.fromByteToMegaOrGiga(file.getFreeSpace()), ")");
        }
        return null;
    }

    public Map<String, Folder> getDeviceFolderStructure() {
        if (this.deviceRepository != null) {
            return this.deviceRepository.getFolderStructure();
        }
        return new HashMap<String, Folder>();
    }

    public Repository getDeviceRepository() {
        return this.deviceRepository;
    }

    public List<AudioFile> getAudioFilesList() {
        if (this.deviceRepository != null) {
            return this.deviceRepository.getAudioFilesList();
        }
        return new ArrayList<AudioFile>();
    }

    public boolean isDeviceConnected() {
        return this.deviceRepository != null;
    }

    public boolean isDevicePath(String string) {
        return string.contains(this.devicePath.toString());
    }

    @Override
    public void notifyCurrentPath(String string) {
    }

    private void notifyDeviceReload(RepositoryLoader repositoryLoader) {
        if (ControllerProxy.getInstance().getNavigationController() != null) {
            GuiHandler.getInstance().hideProgressBar();
            ControllerProxy.getInstance().getNavigationController().notifyDeviceReload();
            Actions.getAction(ConnectDeviceAction.class).setEnabled(repositoryLoader == null);
            Actions.getAction(RefreshDeviceAction.class).setEnabled(repositoryLoader != null);
            Actions.getAction(DisconnectDeviceAction.class).setEnabled(repositoryLoader != null);
            if (repositoryLoader != null) {
                GuiHandler.getInstance().showDeviceInfoOnStatusBar(this.getDeviceData());
            } else {
                GuiHandler.getInstance().hideDeviceInfoOnStatusBar();
            }
            if (repositoryLoader != null) {
                ControllerProxy.getInstance().getNavigationController().setNavigationView(DeviceNavigationView.class.getName());
            }
        }
    }

    @Override
    public void notifyFileLoaded() {
    }

    @Override
    public void notifyFilesInRepository(int n) {
    }

    @Override
    public void notifyFinishRead(RepositoryLoader repositoryLoader) {
        DeviceHandler.getLogger().info("REPOSITORY  ", "Device read");
        this.notifyDeviceReload(repositoryLoader);
        this.actionsAfterConnectDevice();
    }

    private void actionsAfterConnectDevice() {
        DeviceDisconnectionMonitor.startMonitor();
        DeviceDisconnectionMonitor.addListener(this);
        SearchHandler.getInstance().registerSearchableObject(DeviceSearchableObject.getInstance());
        Actions.getAction(CopyPlayListToDeviceAction.class).setEnabled(true);
        Actions.getAction(SynchronizeDeviceWithPlayListAction.class).setEnabled(true);
    }

    @Override
    public void notifyFinishRefresh(RepositoryLoader repositoryLoader) {
        this.notifyDeviceReload(repositoryLoader);
        Actions.getAction(CopyPlayListToDeviceAction.class).setEnabled(true);
        Actions.getAction(SynchronizeDeviceWithPlayListAction.class).setEnabled(true);
    }

    @Override
    public void notifyRemainingTime(long l) {
    }

    @Override
    public void notifyReadProgress() {
    }

    public void refreshDevice() {
        GuiHandler.getInstance().showProgressBar(true, null);
        DeviceHandler.getLogger().info("REPOSITORY  ", "Refreshing device");
        Repository repository = this.deviceRepository;
        this.deviceRepository = new Repository(repository.getFolders());
        this.currentLoader = new RepositoryLoader(repository.getFolders(), repository, this.deviceRepository, true);
        this.currentLoader.addRepositoryLoaderListener(this);
        this.currentLoader.start();
    }

    private void retrieveDevice(File file) {
        DeviceHandler.getLogger().info("REPOSITORY  ", StringUtils.getString("Reading device mounted on ", file));
        this.setDevicePath(file);
        this.deviceId = this.getDeviceIndentificationInfo();
        if (this.deviceId != null) {
            this.deviceRepository = ApplicationStateHandler.getInstance().retrieveDeviceCache(this.deviceId);
            if (this.deviceRepository != null) {
                this.refreshDevice();
                return;
            }
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(file);
        this.deviceRepository = new Repository(arrayList);
        this.currentLoader = new RepositoryLoader(arrayList, null, this.deviceRepository, false);
        this.currentLoader.addRepositoryLoaderListener(this);
        this.currentLoader.start();
    }

    private void setDevicePath(File file) {
        this.devicePath = file;
    }

    public AudioFile getFileIfLoaded(String string) {
        return this.deviceRepository == null ? null : this.deviceRepository.getFile(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDeviceIndentificationInfo() {
        String string;
        block7: {
            string = null;
            BufferedReader bufferedReader = null;
            BufferedWriter bufferedWriter = null;
            try {
                File file = new File(StringUtils.getString(this.devicePath, SystemProperties.FILE_SEPARATOR, ".aTunesDevice"));
                if (file.exists()) {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    string = bufferedReader.readLine();
                    bufferedReader.close();
                } else {
                    string = Long.toString(System.currentTimeMillis());
                    bufferedWriter = new BufferedWriter(new FileWriter(file));
                    bufferedWriter.append(string);
                    bufferedWriter.newLine();
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                ClosingUtils.close(bufferedReader);
            }
            catch (IOException iOException) {
                DeviceHandler.getLogger().error("HANDLER     ", iOException);
                break block7;
            }
            finally {
                ClosingUtils.close(bufferedReader);
                ClosingUtils.close(bufferedWriter);
            }
            ClosingUtils.close(bufferedWriter);
        }
        return string;
    }

    @Override
    public void audioFilesRemoved(List<AudioFile> list) {
        if (!this.isDeviceConnected()) {
            return;
        }
        boolean bl = false;
        for (AudioFile audioFile : list) {
            if (!this.isDevicePath(audioFile.getFile().getAbsolutePath())) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.refreshDevice();
        }
    }

    public int getFilesCopiedToDevice() {
        return this.filesCopiedToDevice;
    }

    public List<AudioFile> getElementsNotPresentInDevice(List<AudioFile> list) {
        ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
        if (list != null && !list.isEmpty()) {
            for (AudioFile audioFile : list) {
                Object object;
                Collection<Object> collection;
                Object object2;
                String string = audioFile.getAlbumArtist() != null && !audioFile.getAlbumArtist().trim().equals("") ? audioFile.getAlbumArtist() : audioFile.getArtist();
                String string2 = audioFile.getAlbum();
                String string3 = audioFile.getTitle();
                if (this.getDeviceArtistStructure().get(string) == null) {
                    arrayList.add(audioFile);
                    continue;
                }
                Artist artist = this.getDeviceArtistStructure().get(string);
                if (ApplicationState.getInstance().isAllowRepeatedSongsInDevice()) {
                    if (artist.getAlbum(string2) == null) {
                        arrayList.add(audioFile);
                        continue;
                    }
                    object2 = artist.getAlbum(string2);
                    collection = ((Album)object2).getAudioFiles();
                    object = new HashSet();
                    for (AudioFile audioFile2 : collection) {
                        ((HashSet)object).add(audioFile2.getTitle());
                    }
                    if (((HashSet)object).contains(string3)) continue;
                    arrayList.add(audioFile);
                    continue;
                }
                object2 = artist.getAudioFiles();
                collection = new HashSet();
                object = object2.iterator();
                while (object.hasNext()) {
                    AudioFile audioFile3 = (AudioFile)object.next();
                    ((HashSet)collection).add(audioFile3.getTitle());
                }
                if (((HashSet)collection).contains(string3)) continue;
                arrayList.add(audioFile);
            }
        }
        return arrayList;
    }

    public List<AudioFile> getElementsNotPresentInList(List<AudioFile> list) {
        ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>(this.getAudioFilesList());
        for (AudioFile audioFile : list) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string = audioFile.getAlbumArtist() != null && !audioFile.getAlbumArtist().trim().equals("") ? audioFile.getAlbumArtist() : audioFile.getArtist();
            String string2 = audioFile.getAlbum();
            String string3 = audioFile.getTitle();
            if (this.getDeviceArtistStructure().get(string) == null) continue;
            Artist artist = this.getDeviceArtistStructure().get(string);
            if (ApplicationState.getInstance().isAllowRepeatedSongsInDevice()) {
                if (artist.getAlbum(string2) == null) continue;
                object4 = artist.getAlbum(string2);
                object3 = ((Album)object4).getAudioFiles();
                object2 = new HashMap();
                object = object3.iterator();
                while (object.hasNext()) {
                    AudioFile audioFile2 = (AudioFile)object.next();
                    ((HashMap)object2).put(audioFile2.getTitle(), audioFile2);
                }
                if (!((HashMap)object2).containsKey(string3)) continue;
                arrayList.remove(((HashMap)object2).get(string3));
                continue;
            }
            object4 = artist.getAudioFiles();
            object3 = new HashMap();
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (AudioFile)object2.next();
                ((HashMap)object3).put(((AudioFile)object).getTitle(), object);
            }
            if (!((HashMap)object3).containsKey(string3)) continue;
            arrayList.remove(((HashMap)object3).get(string3));
        }
        return arrayList;
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
        DeviceConnectionMonitor.startMonitor();
    }

    public Map<String, Year> getYearStructure() {
        if (this.isDeviceConnected()) {
            return this.deviceRepository.getYearStructure();
        }
        return new HashMap<String, Year>();
    }
}

