/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.audioobject;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanel;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanelContent;
import net.sourceforge.atunes.kernel.modules.context.audioobject.AudioObjectBasicInfoContent;
import net.sourceforge.atunes.kernel.modules.context.audioobject.LyricsContent;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.GenericImageSize;
import net.sourceforge.atunes.utils.I18nUtils;

public class AudioObjectContextPanel
extends AbstractContextPanel {
    private static final long serialVersionUID = -7910261492394049289L;
    private List<AbstractContextPanelContent> contents;

    @Override
    protected ImageIcon getContextPanelIcon(AudioObject audioObject) {
        if (audioObject != null) {
            return audioObject.getGenericImage(GenericImageSize.SMALL);
        }
        return Images.getImage("audioFile_little.png");
    }

    @Override
    public String getContextPanelName() {
        return "AUDIOOBJECT";
    }

    @Override
    protected String getContextPanelTitle(AudioObject audioObject) {
        if (audioObject instanceof AudioFile || audioObject instanceof Radio && ((Radio)audioObject).isSongInfoAvailable()) {
            return I18nUtils.getString("SONG");
        }
        if (audioObject instanceof Radio) {
            return I18nUtils.getString("RADIO");
        }
        if (audioObject instanceof PodcastFeedEntry) {
            return I18nUtils.getString("PODCAST_FEED");
        }
        return I18nUtils.getString("SONG");
    }

    @Override
    protected List<AbstractContextPanelContent> getContents() {
        if (this.contents == null) {
            this.contents = new ArrayList<AbstractContextPanelContent>();
            this.contents.add(new AudioObjectBasicInfoContent());
            this.contents.add(new LyricsContent());
        }
        return this.contents;
    }

    @Override
    protected boolean isPanelEnabledForAudioObject(AudioObject audioObject) {
        return audioObject != null;
    }
}

