/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.audioobject;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanelContent;
import net.sourceforge.atunes.kernel.modules.context.ContextHandler;
import net.sourceforge.atunes.kernel.modules.context.audioobject.AudioObjectBasicInfoDataSource;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import org.jdesktop.swingx.border.DropShadowBorder;

public class AudioObjectBasicInfoContent
extends AbstractContextPanelContent {
    private static final long serialVersionUID = 996227362636450601L;
    private JLabel audioObjectImage;
    private JLabel audioObjectTitle;
    private JLabel audioObjectArtist;
    private JLabel audioObjectLastPlayDate;
    private JMenuItem lovedSong;
    private JMenuItem bannedSong;

    public AudioObjectBasicInfoContent() {
        super(new AudioObjectBasicInfoDataSource());
    }

    @Override
    protected void clearContextPanelContent() {
        super.clearContextPanelContent();
        this.audioObjectImage.setIcon(null);
        this.audioObjectImage.setBorder(null);
        this.audioObjectTitle.setText(null);
        this.audioObjectArtist.setText(null);
        this.audioObjectLastPlayDate.setText(null);
        this.lovedSong.setEnabled(false);
        this.bannedSong.setEnabled(false);
    }

    @Override
    protected Map<String, ?> getDataSourceParameters(AudioObject audioObject) {
        HashMap<String, AudioObject> hashMap = new HashMap<String, AudioObject>();
        hashMap.put("AUDIO_OBJECT", audioObject);
        return hashMap;
    }

    @Override
    protected void updateContentWithDataSourceResult(Map<String, ?> map) {
        ImageIcon imageIcon = (ImageIcon)map.get("IMAGE");
        if (imageIcon != null) {
            this.audioObjectImage.setIcon(imageIcon);
        }
        if (map.containsKey("AUDIO_OBJECT")) {
            if (map.get("AUDIO_OBJECT") instanceof AudioFile && imageIcon != null) {
                this.audioObjectImage.setBorder((Border)new DropShadowBorder());
            } else {
                this.audioObjectImage.setBorder(null);
            }
        }
        if (map.containsKey("TITLE")) {
            this.audioObjectTitle.setText((String)map.get("TITLE"));
        }
        if (map.containsKey("ARTIST")) {
            this.audioObjectArtist.setText((String)map.get("ARTIST"));
        }
        if (map.containsKey("LAST_PLAY_DATE")) {
            this.audioObjectLastPlayDate.setText((String)map.get("LAST_PLAY_DATE"));
        }
        this.lovedSong.setEnabled(ApplicationState.getInstance().isLastFmEnabled() && map.get("AUDIO_OBJECT") instanceof AudioFile);
        this.bannedSong.setEnabled(ApplicationState.getInstance().isLastFmEnabled() && map.get("AUDIO_OBJECT") instanceof AudioFile);
    }

    @Override
    protected String getContentName() {
        return I18nUtils.getString("INFO");
    }

    @Override
    protected Component getComponent() {
        this.audioObjectImage = new JLabel();
        this.audioObjectTitle = new JLabel();
        this.audioObjectTitle.setHorizontalAlignment(0);
        this.audioObjectTitle.setFont(Fonts.getContextInformationBigFont());
        this.audioObjectArtist = new JLabel();
        this.audioObjectArtist.setHorizontalAlignment(0);
        this.audioObjectLastPlayDate = new JLabel();
        this.audioObjectLastPlayDate.setHorizontalAlignment(0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        jPanel.add((Component)this.audioObjectImage, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        jPanel.add((Component)this.audioObjectTitle, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        jPanel.add((Component)this.audioObjectArtist, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.audioObjectLastPlayDate, gridBagConstraints);
        return jPanel;
    }

    @Override
    protected List<Component> getOptions() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.lovedSong = new JMenuItem(I18nUtils.getString("ADD_LOVED_SONG_IN_LASTFM"));
        this.lovedSong.addActionListener(new AddLovedSongActionListener());
        this.bannedSong = new JMenuItem(I18nUtils.getString("ADD_BANNED_SONG_IN_LASTFM"));
        this.bannedSong.addActionListener(new AddBannedSongActionListener());
        arrayList.add(this.lovedSong);
        arrayList.add(this.bannedSong);
        return arrayList;
    }

    private static class AddLovedSongActionListener
    implements ActionListener {
        private AddLovedSongActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LastFmService.getInstance().addLovedSong(ContextHandler.getInstance().getCurrentAudioObject());
        }
    }

    private static class AddBannedSongActionListener
    implements ActionListener {
        private AddBannedSongActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LastFmService.getInstance().addBannedSong(ContextHandler.getInstance().getCurrentAudioObject());
        }
    }
}

