/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.artist;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import net.sourceforge.atunes.gui.views.controls.ScrollableFlowPanel;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanelContent;
import net.sourceforge.atunes.kernel.modules.context.AlbumInfo;
import net.sourceforge.atunes.kernel.modules.context.artist.ArtistInfoDataSource;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.DesktopUtils;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import org.jdesktop.swingx.border.DropShadowBorder;

public class ArtistAlbumsFlowContent
extends AbstractContextPanelContent {
    private ScrollableFlowPanel coversPanel;

    public ArtistAlbumsFlowContent() {
        super(new ArtistInfoDataSource());
    }

    @Override
    protected Component getComponent() {
        this.coversPanel = new ScrollableFlowPanel();
        this.coversPanel.setOpaque(false);
        this.coversPanel.setLayout(new FlowLayout());
        return this.coversPanel;
    }

    @Override
    protected String getContentName() {
        return I18nUtils.getString("ALBUMS");
    }

    @Override
    protected Map<String, ?> getDataSourceParameters(AudioObject audioObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("AUDIO_OBJECT", audioObject);
        hashMap.put("ALBUMS", true);
        return hashMap;
    }

    @Override
    protected void updateContentWithDataSourceResult(Map<String, ?> map) {
        if (map != null && map.containsKey("ALBUMS")) {
            List list = (List)map.get("ALBUMS");
            for (AlbumInfo albumInfo : list) {
                this.coversPanel.add(this.getLabelForAlbum(albumInfo));
            }
            this.coversPanel.revalidate();
            this.coversPanel.repaint();
            this.coversPanel.validate();
        }
    }

    @Override
    protected void clearContextPanelContent() {
        super.clearContextPanelContent();
        this.coversPanel.removeAll();
    }

    JLabel getLabelForAlbum(AlbumInfo albumInfo) {
        JLabel jLabel = new JLabel(albumInfo.getCover());
        jLabel.setToolTipText(albumInfo.getTitle());
        if (albumInfo.getCover() == null) {
            jLabel.setPreferredSize(new Dimension(75, 75));
            jLabel.setBorder(BorderFactory.createLineBorder(GuiUtils.getBorderColor()));
        } else {
            jLabel.setBorder((Border)new DropShadowBorder());
        }
        jLabel.addMouseListener(new CoverMouseAdapter(albumInfo, jLabel));
        return jLabel;
    }

    private static final class CoverMouseAdapter
    extends MouseAdapter {
        private final AlbumInfo album;
        private final JLabel coverLabel;

        private CoverMouseAdapter(AlbumInfo albumInfo, JLabel jLabel) {
            this.album = albumInfo;
            this.coverLabel = jLabel;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.coverLabel.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.coverLabel.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            DesktopUtils.openURL(this.album.getUrl());
        }
    }
}

