/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import javax.swing.ImageIcon;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.favorites.FavoritesHandler;
import net.sourceforge.atunes.model.AudioObject;

public class FavoriteColumn
extends AbstractColumn {
    private static final long serialVersionUID = -4652512586792166062L;

    public FavoriteColumn() {
        super("FAVORITES", ImageIcon.class);
        this.setResizable(false);
        this.setWidth(20);
        this.setVisible(true);
    }

    @Override
    protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
        return 0;
    }

    @Override
    public boolean isSortable() {
        return false;
    }

    @Override
    public Object getValueFor(AudioObject audioObject) {
        if (audioObject instanceof Radio) {
            return Images.getImage("empty.png");
        }
        if (audioObject instanceof PodcastFeedEntry) {
            return Images.getImage("empty.png");
        }
        return FavoritesHandler.getInstance().getFavoriteSongsInfo().containsValue(audioObject) ? Images.getImage("favorite.png") : Images.getImage("empty.png");
    }

    @Override
    public String getHeaderText() {
        return "";
    }
}

