/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import java.text.DateFormat;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.model.AudioObject;

public class DateColumn
extends AbstractColumn {
    private static final long serialVersionUID = 6832826017182272636L;
    private final DateFormat dateFormat = DateFormat.getDateInstance();

    public DateColumn() {
        super("DATE", String.class);
        this.setAlignment(0);
        this.setVisible(false);
        this.setUsedForFilter(true);
    }

    @Override
    protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
        if (audioObject.getDate() == null) {
            return 1;
        }
        if (audioObject2.getDate() == null) {
            return -1;
        }
        return audioObject.getDate().compareTo(audioObject2.getDate());
    }

    @Override
    public Object getValueFor(AudioObject audioObject) {
        if (audioObject.getDate() != null) {
            return this.dateFormat.format(audioObject.getDate());
        }
        return "";
    }

    @Override
    public String getValueForFilter(AudioObject audioObject) {
        return this.dateFormat.format(audioObject.getDate());
    }
}

