/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import javax.swing.JLabel;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.repository.favorites.FavoritesHandler;
import net.sourceforge.atunes.model.AudioObject;

public class ArtistColumn
extends AbstractColumn {
    private static final long serialVersionUID = 8144686293055648148L;

    public ArtistColumn() {
        super("ARTIST", JLabel.class);
        this.setVisible(true);
        this.setUsedForFilter(true);
    }

    @Override
    protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
        return audioObject.getArtist().compareTo(audioObject2.getArtist());
    }

    @Override
    public Object getValueFor(AudioObject audioObject) {
        return new JLabel(audioObject.getArtist(), !FavoritesHandler.getInstance().getFavoriteArtistsInfo().containsKey(audioObject.getArtist()) ? null : Images.getImage("artistFavorite.png"), 2);
    }

    @Override
    public String getValueForFilter(AudioObject audioObject) {
        return audioObject.getArtist();
    }
}

