/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import java.io.Serializable;
import java.util.Comparator;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.atunes.kernel.modules.columns.ColumnBean;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.GuiUtils;
import org.commonjukebox.plugins.model.PluginApi;

@PluginApi
public abstract class AbstractColumn
implements Comparable<AbstractColumn>,
Serializable {
    private static final long serialVersionUID = 7407756833207959017L;
    private String columnName;
    private boolean resizable = true;
    private int width = 150;
    private Class<?> columnClass;
    private boolean visible;
    private int order;
    private int alignment = GuiUtils.getComponentOrientationAsSwingConstant();
    private boolean editable = false;
    private boolean usedForFilter = false;
    private transient ColumnSort columnSort;

    public AbstractColumn(String string, Class<?> clazz) {
        this.columnName = string;
        this.columnClass = clazz;
    }

    public void applyColumnBean(ColumnBean columnBean) {
        this.order = columnBean.getOrder();
        this.width = columnBean.getWidth();
        this.visible = columnBean.isVisible();
        this.columnSort = columnBean.getSort();
    }

    @Override
    public int compareTo(AbstractColumn abstractColumn) {
        return Integer.valueOf(this.order).compareTo(abstractColumn.order);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public TableCellEditor getCellEditor() {
        return null;
    }

    public TableCellRenderer getCellRenderer() {
        return null;
    }

    public ColumnBean getColumnBean() {
        ColumnBean columnBean = new ColumnBean();
        columnBean.setOrder(this.order);
        columnBean.setWidth(this.width);
        columnBean.setVisible(this.visible);
        columnBean.setSort(this.columnSort);
        return columnBean;
    }

    public Class<?> getColumnClass() {
        return this.columnClass;
    }

    public String getColumnName() {
        return this.columnName;
    }

    protected abstract int ascendingCompare(AudioObject var1, AudioObject var2);

    public String getHeaderText() {
        return this.columnName;
    }

    public int getOrder() {
        return this.order;
    }

    public abstract Object getValueFor(AudioObject var1);

    public boolean isPlayListExclusive() {
        return false;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isSortable() {
        return true;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setColumnClass(Class<?> clazz) {
        this.columnClass = clazz;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
    }

    public void setValueFor(AudioObject audioObject, Object object) {
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public String toString() {
        return this.columnName;
    }

    public Comparator<AudioObject> getComparator(boolean bl) {
        if (this.columnSort == null) {
            this.columnSort = ColumnSort.ASCENDING;
        } else if (this.columnSort == ColumnSort.ASCENDING && bl) {
            this.columnSort = ColumnSort.DESCENDING;
        } else if (this.columnSort == ColumnSort.DESCENDING && bl) {
            this.columnSort = ColumnSort.ASCENDING;
        }
        return new Comparator<AudioObject>(){

            @Override
            public int compare(AudioObject audioObject, AudioObject audioObject2) {
                return AbstractColumn.this.columnSort == ColumnSort.ASCENDING ? AbstractColumn.this.ascendingCompare(audioObject, audioObject2) : -AbstractColumn.this.ascendingCompare(audioObject, audioObject2);
            }
        };
    }

    public boolean isUsedForFilter() {
        return this.usedForFilter;
    }

    public void setUsedForFilter(boolean bl) {
        this.usedForFilter = bl;
    }

    public String getValueForFilter(AudioObject audioObject) {
        return this.getValueFor(audioObject).toString();
    }

    public void setColumnSort(ColumnSort columnSort) {
        this.columnSort = columnSort;
    }

    public ColumnSort getColumnSort() {
        return this.columnSort;
    }

    public static enum ColumnSort {
        ASCENDING,
        DESCENDING;

    }
}

