/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.cdripper;

import java.io.File;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.cdripper.ProgressListener;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.AbstractCdToWavConverter;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.NoCdListener;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.model.CDInfo;
import net.sourceforge.atunes.kernel.modules.cdripper.encoders.Encoder;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.FileNameUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class CdRipper {
    public static final String ARTIST_PATTERN = "%A";
    public static final String ALBUM_PATTERN = "%L";
    public static final String TITLE_PATTERN = "%T";
    public static final String TRACK_NUMBER = "%N";
    private Logger logger;
    private AbstractCdToWavConverter cdToWavConverter;
    private Encoder encoder;
    private ProgressListener listener;
    private ProgressListener encoderListener;
    private boolean interrupted;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private String artist;
    private String album;
    private int year;
    private String genre;
    private String fileNamePattern;

    public CdRipper() {
        this.cdToWavConverter = AbstractCdToWavConverter.createNewConverterForOS();
    }

    private boolean checkFolder(File file) {
        return file.exists() && file.isDirectory();
    }

    public CDInfo getCDInfo() {
        return this.cdToWavConverter.retrieveDiscInformation();
    }

    private String getFileName(List<String> list, int n, String string) {
        DecimalFormat decimalFormat = new DecimalFormat("00");
        if (this.fileNamePattern == null) {
            return StringUtils.getString("track", n, Character.valueOf('.'), string);
        }
        String string2 = StringUtils.getString(this.fileNamePattern, Character.valueOf('.'), string);
        string2 = string2.replaceAll(ARTIST_PATTERN, this.artist);
        string2 = string2.replaceAll(ALBUM_PATTERN, this.album);
        string2 = string2.replaceAll(TRACK_NUMBER, decimalFormat.format(n));
        string2 = list.size() > n - 1 ? string2.replaceAll(TITLE_PATTERN, list.get(n - 1).replace("\\", "\\\\").replace("$", "\\$")) : string2.replaceAll(TITLE_PATTERN, StringUtils.getString("track", n));
        string2 = FileNameUtils.getValidFileName(string2);
        return string2;
    }

    public boolean ripTracks(List<Integer> list, List<String> list2, File file, List<String> list3, List<String> list4, boolean bl) {
        String string = this.encoder != null ? this.encoder.getExtensionOfEncodedFiles() : "wav";
        this.getLogger().info("RIPPER      ", StringUtils.getString("Running cd ripping of ", list.size(), " to ", string, "..."));
        long l = System.currentTimeMillis();
        if (!this.checkFolder(file)) {
            this.getLogger().error("RIPPER      ", "Folder " + file + " not found or not a directory");
            return false;
        }
        if (this.listener != null && this.encoderListener != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CdRipper.this.listener.notifyProgress(0);
                    CdRipper.this.encoderListener.notifyProgress(0);
                }
            });
        }
        File file2 = null;
        File file3 = null;
        for (int i = 0; i < list.size(); ++i) {
            if (this.interrupted) continue;
            int n = list.get(i);
            file2 = new File(StringUtils.getString(file.getAbsolutePath(), "/track", n, ".wav"));
            if (this.encoder != null) {
                file3 = new File(StringUtils.getString(file.getAbsolutePath(), Character.valueOf('/'), this.getFileName(list2, n, string)));
            }
            File file4 = file3;
            File file5 = file2;
            File file6 = new File(StringUtils.getString(file.getAbsolutePath(), "/track", n, ".inf"));
            boolean bl2 = false;
            if (!this.interrupted) {
                bl2 = bl ? this.cdToWavConverter.cdda2wav(n, file2, true) : this.cdToWavConverter.cdda2wav(n, file2);
            }
            boolean bl3 = bl2;
            EncodeFileRunnable encodeFileRunnable = new EncodeFileRunnable(n, list3, list4, bl3, file4, file6, list2, file5);
            this.executorService.execute(encodeFileRunnable);
            if (i == list.size() - 1) {
                this.executorService.shutdown();
                try {
                    this.executorService.awaitTermination(100L, TimeUnit.MINUTES);
                }
                catch (InterruptedException interruptedException) {
                    this.getLogger().error("RIPPER      ", interruptedException);
                }
            }
            if (this.listener == null) continue;
            final int n2 = i;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CdRipper.this.listener.notifyProgress(n2 + 1);
                }
            });
        }
        long l2 = System.currentTimeMillis();
        this.getLogger().info("RIPPER      ", StringUtils.getString("Process finished in ", (double)(l2 - l) / 1000.0, " seconds"));
        return true;
    }

    public void setAlbum(String string) {
        this.album = string == null || string.equals("") ? Album.getUnknownAlbum() : string;
        if (this.encoder != null) {
            this.encoder.setAlbum(this.album);
        }
    }

    public void setArtist(String string) {
        this.artist = string == null || string.equals("") ? Artist.getUnknownArtist() : string;
        if (this.encoder != null) {
            this.encoder.setArtist(this.artist);
        }
    }

    public void setDecoderListener(ProgressListener progressListener) {
        this.cdToWavConverter.setListener(progressListener);
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public void setEncoderListener(ProgressListener progressListener) {
        if (this.encoder != null) {
            this.encoder.setListener(progressListener);
        }
    }

    public void setFileNamePattern(String string) {
        this.fileNamePattern = string;
    }

    public void setGenre(String string) {
        this.genre = string;
        if (this.encoder != null) {
            this.encoder.setGenre(this.genre);
        }
    }

    public void setNoCdListener(NoCdListener noCdListener) {
        this.cdToWavConverter.setNoCdListener(noCdListener);
    }

    public void setTotalProgressListener(ProgressListener progressListener) {
        this.listener = progressListener;
    }

    public void setYear(int n) {
        this.year = n;
        if (this.encoder != null) {
            this.encoder.setYear(this.year);
        }
    }

    public void stop() {
        this.interrupted = true;
        this.cdToWavConverter.stop();
        if (this.encoder != null) {
            this.encoder.stop();
        }
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private final class EncodeFileRunnable
    implements Runnable {
        private final int trackNumber;
        private final List<String> artistNames;
        private final List<String> composerNames;
        private final boolean ripResultFinal;
        private final File resultFileTemp;
        private final File infFileTemp;
        private final List<String> titles;
        private final File wavFileTemp;

        private EncodeFileRunnable(int n, List<String> list, List<String> list2, boolean bl, File file, File file2, List<String> list3, File file3) {
            this.trackNumber = n;
            this.artistNames = list;
            this.composerNames = list2;
            this.ripResultFinal = bl;
            this.resultFileTemp = file;
            this.infFileTemp = file2;
            this.titles = list3;
            this.wavFileTemp = file3;
        }

        @Override
        public void run() {
            if (!CdRipper.this.interrupted && this.ripResultFinal && CdRipper.this.encoder != null) {
                boolean bl = CdRipper.this.encoder.encode(this.wavFileTemp, this.resultFileTemp, this.titles != null && this.titles.size() >= this.trackNumber ? this.titles.get(this.trackNumber - 1) : null, this.trackNumber, this.artistNames.size() > this.trackNumber - 1 ? this.artistNames.get(this.trackNumber - 1) : Artist.getUnknownArtist(), this.composerNames.size() > this.trackNumber - 1 ? this.composerNames.get(this.trackNumber - 1) : "");
                if (bl && CdRipper.this.encoderListener != null && !CdRipper.this.interrupted) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CdRipper.this.encoderListener.notifyFileFinished(EncodeFileRunnable.this.resultFileTemp);
                        }
                    });
                }
                CdRipper.this.getLogger().info("RIPPER      ", "Deleting wav file...");
                this.wavFileTemp.delete();
                this.infFileTemp.delete();
                if (CdRipper.this.interrupted && this.resultFileTemp != null) {
                    this.resultFileTemp.delete();
                }
            } else if (CdRipper.this.interrupted) {
                this.wavFileTemp.delete();
                this.infFileTemp.delete();
            } else if (!this.ripResultFinal) {
                CdRipper.this.getLogger().error("RIPPER      ", StringUtils.getString("Rip failed. Skipping track ", this.trackNumber, "..."));
            }
        }
    }
}

