/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.ripcd;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.gui.views.dialogs.RipCdDialog;
import net.sourceforge.atunes.kernel.controllers.ripcd.RipCdDialogController;
import net.sourceforge.atunes.kernel.modules.cdripper.RipperHandler;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.utils.DateUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class RipCdDialogListener
extends KeyAdapter
implements ActionListener {
    private RipCdDialog ripCdDialog;
    private RipCdDialogController ripCdDialogController;

    public RipCdDialogListener(RipCdDialog ripCdDialog, RipCdDialogController ripCdDialogController) {
        this.ripCdDialog = ripCdDialog;
        this.ripCdDialogController = ripCdDialogController;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ripCdDialog.getOk()) {
            this.ripCdDialogController.setCancelled(false);
            this.ripCdDialogController.setArtist(this.ripCdDialog.getArtistTextField().getText());
            this.ripCdDialogController.setAlbum(this.ripCdDialog.getAlbumTextField().getText());
            try {
                this.ripCdDialogController.setYear(Integer.parseInt(this.ripCdDialog.getYearTextField().getText()));
            }
            catch (NumberFormatException numberFormatException) {
                this.ripCdDialogController.setYear(DateUtils.getCurrentYear());
            }
            this.ripCdDialogController.setGenre(this.ripCdDialog.getGenreComboBox().getSelectedItem().toString());
            this.ripCdDialogController.setFolder(this.ripCdDialog.getFolderName().getText());
            this.ripCdDialog.setVisible(false);
        } else if (actionEvent.getSource() == this.ripCdDialog.getCancel()) {
            this.ripCdDialogController.setCancelled(true);
            this.ripCdDialog.setVisible(false);
        } else if (actionEvent.getSource() == this.ripCdDialog.getFolderSelectionButton()) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showDialog(this.ripCdDialog, I18nUtils.getString("SELECT_FOLDER"));
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.ripCdDialog.getFolderName().setText(file.getAbsolutePath());
                this.ripCdDialogController.setFolderNameEdited(true);
            }
        } else if (actionEvent.getSource() == this.ripCdDialog.getFormat()) {
            String[] stringArray = RipperHandler.getInstance().getEncoderQualities((String)this.ripCdDialog.getFormat().getSelectedItem());
            this.ripCdDialog.getQualityComboBox().setEnabled(stringArray.length > 0);
            this.ripCdDialog.getQualityComboBox().setModel(new DefaultComboBoxModel<String>(stringArray));
            this.ripCdDialog.getQualityComboBox().setSelectedItem(RipperHandler.getInstance().getEncoderDefaultQuality((String)this.ripCdDialog.getFormat().getSelectedItem()));
        } else if (actionEvent.getSource() == this.ripCdDialog.getTitlesButton()) {
            RipperHandler.getInstance().fillSongTitles(this.ripCdDialog.getArtistTextField().getText(), this.ripCdDialog.getAlbumTextField().getText());
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.ripCdDialog.getFolderName() || keyEvent.getSource() == this.ripCdDialog.getAlbumTextField()) {
            this.ripCdDialogController.setFolderNameEdited(true);
        }
        if (keyEvent.getSource() == this.ripCdDialog.getArtistTextField() || keyEvent.getSource() == this.ripCdDialog.getAlbumTextField()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String string = RipCdDialogListener.this.ripCdDialog.getArtistTextField().getText();
                    String string2 = RipCdDialogListener.this.ripCdDialog.getAlbumTextField().getText();
                    String string3 = RepositoryHandler.getInstance().getRepositoryPath();
                    boolean bl = !string.equals("") && !string2.equals("");
                    RipCdDialogListener.this.ripCdDialog.getTitlesButton().setEnabled(bl);
                    if (!RipCdDialogListener.this.ripCdDialogController.isFolderNameEdited()) {
                        if (bl) {
                            RipCdDialogListener.this.ripCdDialog.getFolderName().setText(StringUtils.getString(string3, SystemProperties.FILE_SEPARATOR, string, SystemProperties.FILE_SEPARATOR, string2));
                        } else if (string.equals("")) {
                            RipCdDialogListener.this.ripCdDialog.getFolderName().setText(StringUtils.getString(string3, SystemProperties.FILE_SEPARATOR, string2));
                        } else {
                            RipCdDialogListener.this.ripCdDialog.getFolderName().setText(StringUtils.getString(string3, SystemProperties.FILE_SEPARATOR, string));
                        }
                    }
                }
            });
        }
    }
}

